/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.cdc.adapter.impl;

import com.xforceplus.ultraman.cdc.adapter.CDCFilter;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class TypeBasedCDCFilter
implements CDCFilter {
    private CdcConfig configs;
    private EntityClassEngine engine;

    public TypeBasedCDCFilter(EntityClassEngine engine, CdcConfig configs) {
        this.configs = configs;
        this.engine = engine;
    }

    @Override
    public boolean isDoIndexSync(OqsEngineEntity oqsEngineEntity) {
        EntityClassRef entityClassRef = oqsEngineEntity.getEntityClassRef();
        Optional target = this.engine.load(Long.toString(entityClassRef.getId()), entityClassRef.getProfile());
        if (target.isPresent()) {
            boolean isPassed = this.checkSync((IEntityClass)target.get());
            if (isPassed) {
                return true;
            }
            Collection tuple2s = ((IEntityClass)target.get()).reverseToOneRelations();
            return Optional.ofNullable(tuple2s).orElseGet(Collections::emptyList).stream().anyMatch(x -> {
                Optional related = this.engine.load((String)x._2, "");
                return related.filter(this::checkSync).isPresent();
            });
        }
        return false;
    }

    private boolean checkSync(IEntityClass entityClass) {
        List includes = this.configs.getInclude();
        if (includes != null && !includes.isEmpty()) {
            return includes.stream().anyMatch(x -> entityClass.code().equalsIgnoreCase((String)x));
        }
        List excludes = this.configs.getExclude();
        if (excludes != null && !excludes.isEmpty()) {
            return excludes.stream().noneMatch(x -> entityClass.code().equalsIgnoreCase((String)x));
        }
        return true;
    }
}

