/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.cdc.reader;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.xforceplus.ultraman.cdc.reader.CDCConfigResolver;
import com.xforceplus.ultraman.cdc.reader.CDCPropertyPackageInternal;
import com.xforceplus.ultraman.cdc.reader.CanalPropertiesReader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDCResolver
implements CDCConfigResolver {
    private Logger logger = LoggerFactory.getLogger(CDCResolver.class);
    private static short DEFAULT_CLIENT_ID = (short)999;
    private static short DEFAULT_SLAVE_ID = (short)899;
    private static final String CDC_MODEL_PATH = "cdcs.model";
    private static final String CDC_FORCE_LOCAL = "cdcs.forceLocal";
    private static final String CDC_PROPERTIES_PATH = "cdcs.properties";
    private short clientIdStart = DEFAULT_CLIENT_ID;
    private short slaveIdStart = DEFAULT_SLAVE_ID;

    @Override
    public CDCPropertyPackageInternal resolve(Config config) {
        ConfigObject configObject = config.getObject("cdcs");
        if (configObject.isEmpty()) {
            throw new RuntimeException("\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u6570\u636e\u6e90");
        }
        CDCPropertyPackageInternal.Model model = null;
        if (config.hasPath(CDC_MODEL_PATH)) {
            model = this.buildModel(config, CDC_MODEL_PATH);
        }
        boolean forceLocal = false;
        this.logger.info("cdc model : {}", (Object)model);
        if (null == model) {
            throw new RuntimeException("\u5fc5\u987b\u5236\u5b9aCDC-SERVER\u542f\u52a8\u6a21\u5f0fLOCAL/REMOTE");
        }
        if (config.hasPath(CDC_PROPERTIES_PATH)) {
            return this.buildCDCProperty(model, config.getConfigList(CDC_PROPERTIES_PATH));
        }
        throw new RuntimeException("No Master datasource config");
    }

    private CDCPropertyPackageInternal.Model buildModel(Config config, String path) {
        String modelString = config.getString(path);
        if (null != modelString && !modelString.isEmpty()) {
            return CDCPropertyPackageInternal.Model.instance(modelString);
        }
        return null;
    }

    private CDCPropertyPackageInternal buildCDCProperty(CDCPropertyPackageInternal.Model model, List<Config> configs) {
        CDCPropertyPackageInternal cdcPropertyPackageInternal = new CDCPropertyPackageInternal();
        cdcPropertyPackageInternal.setModel(model);
        for (Config config : configs) {
            String zkServers;
            int threadBatchSize;
            int batchSize;
            String destination = config.getString("destination");
            if (null == destination || destination.isEmpty()) {
                throw new IllegalArgumentException("destination could not be null.");
            }
            String filter = config.getString("filter");
            if (null == filter || filter.isEmpty()) {
                throw new IllegalArgumentException("filter could not be null.");
            }
            String masterHost = config.getString("masterHost");
            if (null == masterHost || masterHost.isEmpty()) {
                throw new IllegalArgumentException("hostName could not be null.");
            }
            int masterPort = config.getInt("masterPort");
            String masterUser = config.getString("masterUser");
            String masterPassword = config.getString("masterPassword");
            CanalPropertiesReader canalPropertiesReader = new CanalPropertiesReader(masterHost, masterPort, masterUser, masterPassword, destination, filter);
            short s = this.clientIdStart;
            this.clientIdStart = (short)(s - 1);
            canalPropertiesReader.setClientId(s);
            if (config.hasPath("batchSize") && (batchSize = config.getInt("batchSize")) > 0) {
                canalPropertiesReader.setBatchSize(batchSize);
                canalPropertiesReader.setMemoryStorageBufferSize(batchSize);
            }
            if (config.hasPath("threadBatchSize") && (threadBatchSize = config.getInt("threadBatchSize")) > 0) {
                canalPropertiesReader.setThreadBatchSize(threadBatchSize);
            }
            if (config.hasPath("zkServers") && null != (zkServers = config.getString("zkServers")) && !zkServers.isEmpty()) {
                canalPropertiesReader.setZkServers(zkServers);
                this.logger.info("zkServers : {}", (Object)zkServers);
            }
            if (model.equals((Object)CDCPropertyPackageInternal.Model.LOCAL)) {
                String logFile;
                String dataDir;
                if (config.hasPath("dataDir") && null != (dataDir = config.getString("dataDir")) && !dataDir.isEmpty()) {
                    canalPropertiesReader.setDataDir(dataDir);
                }
                if (config.hasPath("logFile") && null != (logFile = config.getString("logFile")) && !logFile.isEmpty()) {
                    canalPropertiesReader.setMasterLogFile(logFile);
                }
                short s2 = this.slaveIdStart;
                this.slaveIdStart = (short)(s2 - 1);
                canalPropertiesReader.setSlaveId(s2);
                if (config.hasPath("resetMeta")) {
                    boolean resetMeta = config.getBoolean("resetMeta");
                    canalPropertiesReader.setResetMeta(resetMeta);
                }
            }
            cdcPropertyPackageInternal.addWithDuplicateIgnore(canalPropertiesReader);
        }
        return cdcPropertyPackageInternal;
    }
}

