/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.cdc.reader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalPropertiesReader {
    private static final Logger logger = LoggerFactory.getLogger(CanalPropertiesReader.class);
    private static final String META = "meta.dat";
    private static final String DEFAULT_DESTINATION = "oqsengine";
    private static final String DEFAULT_FILTER = ".*\\..*";
    private int masterPort;
    private String masterHost;
    private String masterUser;
    private String masterPasswd;
    private int batchSize = 1024;
    private String filter = ".*\\..*";
    private String blackFilter = null;
    private String destination = "oqsengine";
    private int threadBatchSize;
    private String zkServers;
    private String kafkaServers;
    private String kafkaTopic;
    private Integer kafkaTopicPartition = null;
    private String kafkaGroupId;
    private String dataDir = "/opt";
    private int memoryStorageBufferSize = 131072;
    private long slaveId = 123L;
    private short clientId = (short)1001;
    private String masterLogFile;
    private boolean resetMeta = false;
    private String desc = "canal-server for oqs binlog sync.";

    public CanalPropertiesReader(String masterHost, int masterPort, String masterUser, String masterPasswd, String destination, String filter, String blackFilter) {
        this.masterPort = masterPort;
        this.masterHost = masterHost;
        this.masterUser = masterUser;
        this.masterPasswd = masterPasswd;
        this.destination = destination;
        this.filter = filter;
        this.blackFilter = blackFilter;
    }

    public CanalPropertiesReader(String masterHost, int masterPort, String masterUser, String masterPasswd) {
        this(masterHost, masterPort, masterUser, masterPasswd, DEFAULT_DESTINATION, DEFAULT_FILTER, null);
    }

    public short getClientId() {
        return this.clientId;
    }

    public void setClientId(short clientId) {
        this.clientId = clientId;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getKafkaTopic() {
        return this.kafkaTopic;
    }

    public void setKafkaTopic(String kafkaTopic) {
        this.kafkaTopic = kafkaTopic;
    }

    public Integer getKafkaTopicPartition() {
        return this.kafkaTopicPartition;
    }

    public String getKafkaGroupId() {
        return this.kafkaGroupId;
    }

    public void setKafkaTopicPartition(Integer kafkaTopicPartition) {
        this.kafkaTopicPartition = kafkaTopicPartition;
    }

    public void setKafkaGroupId(String kafkaGroupId) {
        this.kafkaGroupId = kafkaGroupId;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getBlackFilter() {
        return this.blackFilter;
    }

    public void setBlackFilter(String blackFilter) {
        this.blackFilter = blackFilter;
    }

    public long getSlaveId() {
        return this.slaveId;
    }

    public void setSlaveId(long slaveId) {
        this.slaveId = slaveId;
    }

    public int getMemoryStorageBufferSize() {
        return this.memoryStorageBufferSize;
    }

    public void setMemoryStorageBufferSize(int memoryStorageBufferSize) {
        this.memoryStorageBufferSize = memoryStorageBufferSize;
    }

    public int getMasterPort() {
        return this.masterPort;
    }

    public String getMasterHost() {
        return this.masterHost;
    }

    public String getMasterUser() {
        return this.masterUser;
    }

    public String getMasterPasswd() {
        return this.masterPasswd;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getKafkaServers() {
        return this.kafkaServers;
    }

    public void setKafkaServers(String kafkaServers) {
        this.kafkaServers = kafkaServers;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getMasterLogFile() {
        return this.masterLogFile;
    }

    public void setMasterLogFile(String masterLogFile) {
        this.masterLogFile = masterLogFile;
    }

    public boolean isResetMeta() {
        return this.resetMeta;
    }

    public void setResetMeta(boolean resetMeta) {
        this.resetMeta = resetMeta;
    }

    public String fullLogFile() {
        return this.dataDir + "/" + this.destination + "/" + META;
    }

    public int getThreadBatchSize() {
        return this.threadBatchSize;
    }

    public void setThreadBatchSize(int threadBatchSize) {
        this.threadBatchSize = threadBatchSize;
    }

    public String getZkServers() {
        return this.zkServers;
    }

    public void setZkServers(String zkServers) {
        this.zkServers = zkServers;
    }
}

