package com.xforceplus.ultraman.cdc.core.local.embed;

import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.Message;
import com.xforceplus.ultraman.cdc.CDCLifeCycle;
import com.xforceplus.ultraman.cdc.reader.CanalPropertiesReader;
import io.vavr.Tuple2;
import java.util.Collection;

/**
 * Created by justin.xu on 08/2022.
 *
 * @since 1.8
 */
public interface SourceDataProducer extends CDCLifeCycle {

    /**
     * 订阅当前的数据消费者.
     * 由于canal instance限制，目前只支持单一的消费者.
     *
     * @return true 订阅成功/false 已经被其他注册.
     */
    boolean singletonRegistry(ClientIdentity clientIdentity);

    /**
     * 获取clientIdentities.
     *
     * @return List<ClientIdentity>.
     */
    Collection<Tuple2<ClientIdentity, CanalPropertiesReader>> clientIdentityWithReader();

    /**
     * 获取数据.
     *
     * @return message数据消费.
     */
    Message onMessage(ClientIdentity clientIdentity, int batchSize);

    /**
     * 批次确认.
     *
     * @param batchId 批次ID.
     */
    void ack(ClientIdentity clientIdentity, long batchId);

    /**
     * 批次回滚.
     *
     * @param batchId 批次ID.
     */
    void rollback(ClientIdentity clientIdentity, long batchId);
}
