package com.xforceplus.ultraman.cdc.reader;

import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by justin.xu on 06/2023.
 *
 * @since 1.8
 */
public class CDCPropertyPackage {

    private Logger log = LoggerFactory.getLogger(CDCPropertyPackage.class);

    private CDCPropertyPackageInternal internal;

    /**
     * 数据源包装实例.
     */
    public CDCPropertyPackage(CDCPropertyPackageInternal internal) {
        this.internal = internal;
    }

    public Collection<CanalPropertiesReader> readers() {
        return internal.getCanalPropertiesReaders().values();
    }

    public Optional<CanalPropertiesReader> find(String destination) {
        return Optional.ofNullable(internal.getCanalPropertiesReaders().get(destination));
    }

    public CDCPropertyPackageInternal.Model model() {
        return internal.getModel();
    }
    
    public boolean forceLocal() {
        return false; 
    }
}
