package com.xforceplus.ultraman.cdc.reader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by justin.xu on 08/2022.
 *
 * @since 1.8
 */
public class CanalPropertiesReader {

    private static final Logger logger = LoggerFactory.getLogger(CanalPropertiesReader.class);

    private static final String META = "meta.dat";
    private static final String DEFAULT_DESTINATION = "oqsengine";
    private static final String DEFAULT_FILTER = ".*\\..*";

    private int masterPort;
    private String masterHost;
    private String masterUser;
    private String masterPasswd;
    private int batchSize = 1024;
    private String filter = DEFAULT_FILTER;

    private String blackFilter = null;
    private String destination = DEFAULT_DESTINATION;
    private int threadBatchSize;

    private String zkServers;
    
    private String kafkaServers;
    
    private String kafkaTopic;
    
    private Integer kafkaTopicPartition = null;
    
    private String kafkaGroupId;
    
    private String dataDir = "/opt";
    private int memoryStorageBufferSize = 128 * 1024;
    private long slaveId = 123L;

    private short clientId = 1001;
    
    private String masterLogFile;
    private boolean resetMeta = false;

    private String desc = "canal-server for oqs binlog sync.";

    public CanalPropertiesReader(String masterHost, int masterPort, String masterUser, String masterPasswd, String destination, String filter, String blackFilter) {
        this.masterPort = masterPort;
        this.masterHost = masterHost;
        this.masterUser = masterUser;
        this.masterPasswd = masterPasswd;
        this.destination = destination;
        this.filter = filter;
        this.blackFilter = blackFilter;
    }

    public CanalPropertiesReader(String masterHost, int masterPort, String masterUser, String masterPasswd) {
        this(masterHost, masterPort, masterUser, masterPasswd, DEFAULT_DESTINATION, DEFAULT_FILTER, null);
    }

    public short getClientId() {
        return clientId;
    }

    public void setClientId(short clientId) {
        this.clientId = clientId;
    }

    public int getBatchSize() {
        return batchSize;
    }

    public String getKafkaTopic() {
        return kafkaTopic;
    }

    public void setKafkaTopic(String kafkaTopic) {
        this.kafkaTopic = kafkaTopic;
    }

    public Integer getKafkaTopicPartition() {
        return kafkaTopicPartition;
    }

    public String getKafkaGroupId() {
        return kafkaGroupId;
    }

    public void setKafkaTopicPartition(Integer kafkaTopicPartition) {
        this.kafkaTopicPartition = kafkaTopicPartition;
    }

    public void setKafkaGroupId(String kafkaGroupId) {
        this.kafkaGroupId = kafkaGroupId;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getFilter() {
        return filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getBlackFilter() {
        return blackFilter;
    }

    public void setBlackFilter(String blackFilter) {
        this.blackFilter = blackFilter;
    }

    public long getSlaveId() {
        return slaveId;
    }

    public void setSlaveId(long slaveId) {
        this.slaveId = slaveId;
    }

    public int getMemoryStorageBufferSize() {
        return memoryStorageBufferSize;
    }

    public void setMemoryStorageBufferSize(int memoryStorageBufferSize) {
        this.memoryStorageBufferSize = memoryStorageBufferSize;
    }

    public int getMasterPort() {
        return masterPort;
    }

    public String getMasterHost() {
        return masterHost;
    }

    public String getMasterUser() {
        return masterUser;
    }

    public String getMasterPasswd() {
        return masterPasswd;
    }

    public String getDataDir() {
        return dataDir;
    }

    public String getKafkaServers() {
        return kafkaServers;
    }

    
    public void setKafkaServers(String kafkaServers) {
        this.kafkaServers = kafkaServers;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return destination;
    }

    public String getMasterLogFile() {
        return masterLogFile;
    }

    public void setMasterLogFile(String masterLogFile) {
        this.masterLogFile = masterLogFile;
    }

    public boolean isResetMeta() {
        return resetMeta;
    }

    public void setResetMeta(boolean resetMeta) {
        this.resetMeta = resetMeta;
    }

    public String fullLogFile() {
        return dataDir + "/" + destination + "/" + META;
    }

    public int getThreadBatchSize() {
        return threadBatchSize;
    }

    public void setThreadBatchSize(int threadBatchSize) {
        this.threadBatchSize = threadBatchSize;
    }

    public String getZkServers() {
        return zkServers;
    }

    public void setZkServers(String zkServers) {
        this.zkServers = zkServers;
    }
}
