package com.xforceplus.ultraman.cdc.adapter.impl;

import com.xforceplus.ultraman.cdc.adapter.CDCFilter;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import io.vavr.Tuple2;
import org.apache.tinkerpop.gremlin.process.traversal.P;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * an important type based cdcFilter
 */
public class TypeBasedCDCFilter implements CDCFilter {

    private CdcConfig configs;

    private EntityClassEngine engine;

    public TypeBasedCDCFilter(EntityClassEngine engine, CdcConfig configs) {
        this.configs = configs;
        this.engine = engine;
    }

    @Override
    public boolean isDoIndexSync(OqsEngineEntity oqsEngineEntity) {
        EntityClassRef entityClassRef = oqsEngineEntity.getEntityClassRef();
        Optional<IEntityClass> target = engine.load(Long.toString(entityClassRef.getId()), entityClassRef.getProfile());
        if(target.isPresent()) {
            boolean isPassed = checkSync(target.get());
            if (isPassed) {
                return true;
            }

            Collection<Tuple2<String, String>> tuple2s = target.get().reverseToOneRelations();
            return Optional.ofNullable(tuple2s).orElseGet(Collections::emptyList).stream().anyMatch(x -> {
                Optional<IEntityClass> related = engine.load(x._2, "");
                return related.filter(this::checkSync).isPresent();
            });
        } else {
            return false;
        }
    }
    
    private boolean checkSync(IEntityClass entityClass) {
        List<String> includes = configs.getInclude();
        if (includes != null && !includes.isEmpty()) {
            return includes.stream().anyMatch(x -> entityClass.code().equalsIgnoreCase(x));
        }

        List<String> excludes = configs.getExclude();
        if (excludes != null && !excludes.isEmpty()) {
            return excludes.stream().noneMatch(x -> entityClass.code().equalsIgnoreCase(x));
        }

        return true;
    }
}
