package com.xforceplus.ultraman.cdc.reader;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by justin.xu on 06/2023.
 *
 * @since 1.8
 */
public class CDCPropertyPackageInternal {

    private Logger log = LoggerFactory.getLogger(CDCPropertyPackageInternal.class);

    private Map<String, CanalPropertiesReader> canalPropertiesReaders = new LinkedHashMap<>();
    private Model model;

    public Map<String, CanalPropertiesReader> getCanalPropertiesReaders() {
        return canalPropertiesReaders;
    }

    public void addWithDuplicateIgnore(CanalPropertiesReader canalPropertiesReader) {
        if (null != canalPropertiesReader.getDestination() && !canalPropertiesReader.getDestination().isEmpty()) {
            canalPropertiesReaders.putIfAbsent(canalPropertiesReader.getDestination(), canalPropertiesReader);
        } else {
            log.warn("destination could not be null.");
        }
    }

    public Model getModel() {
        return model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public static enum Model {
        REMOTE,
        LOCAL;

        public static Model instance(String name) {
            for (Model model : Model.values()) {
                if (model.name().equalsIgnoreCase(name)) {
                    return model;
                }
            }

            return null;
        }
    }
}
