package com.xforceplus.ultraman.cdc.reader;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by justin.xu on 06/2023.
 *
 * @since 1.8
 */
public class ReaderFactory {

    private static Logger logger = LoggerFactory.getLogger(ReaderFactory.class);

    /**
     * 数据源构造,会试图读取构造三个数据源列表.
     * 索引读,索引写和主库.
     *
     * @return 构造的数据源包装.
     */
    public static CDCPropertyPackage build(CDCConfigResolver resolver, String[] activeProfiles) {

        String baseName = "oqs-cdc";
        Config baseConfig = ConfigFactory.load(baseName);
        Config config = null;

        if(activeProfiles.length > 0) {
            String activeProfile = activeProfiles[0];
            if(!activeProfile.equalsIgnoreCase("DEFAULT") && !StringUtils.isEmpty(activeProfile)) {
                //try find
                try {
                    Config extend = ConfigFactory.load(baseName.concat("-").concat(activeProfile));
                    config = extend.withFallback(baseConfig).resolve();
                } catch (Throwable throwable) {
                    //slient
                    logger.warn("Cannot find related {}", activeProfile);
                }
            }
        }

        if(config == null) {
            config = baseConfig;
        }

        CDCPropertyPackageInternal result = resolver.resolve(config);
        return new CDCPropertyPackage(result);
    }

}
