package com.xforceplus.ultraman.cdc.adapter;

import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @program: ultraman-oqsengine-plus
 * @ClassName ElasticSearchSerivce
 * @description:
 * @author: WanYiO
 * @create: 2023-05-12 17:24
 * @Version 1.0
 **/
public interface EngineAdapterService {

  List<CDCFilter> getFilters();

  List<IndexUpsertBeforeCallBack> getCallBacks();

  boolean initMetedataInitStatus();

  default boolean batchUpsertOperation(Collection<OqsEngineEntity> oqsEngineEntities) {
    List<OqsEngineEntity> filteredOqsEntities = Optional.ofNullable(oqsEngineEntities)
        .orElseGet(Collections::emptyList)
        .stream().filter(x -> getFilters().stream().allMatch(f ->
            f.isDoIndexSync(x)
        ))
        .collect(Collectors.toList());

    List<OqsEngineEntity> modified = filteredOqsEntities.stream().map(x -> {
      Optional<Function<OqsEngineEntity, OqsEngineEntity>> reduce = getCallBacks().stream()
          .map(cb -> (Function<OqsEngineEntity, OqsEngineEntity>) cb)
          .reduce(Function::andThen);
      if (reduce.isPresent()) {
        return reduce.get().apply(x);
      } else {
        return x;
      }
    }).collect(Collectors.toList());

    return sync(modified);
  }

  boolean sync(List<OqsEngineEntity> oqsEngineEntities);
}