package com.xforceplus.ultraman.cdc.core.local.embed;

import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.Message;
import com.xforceplus.ultraman.cdc.processor.DataProcessor;
import com.xforceplus.ultraman.cdc.reader.CDCPropertyPackage;
import com.xforceplus.ultraman.cdc.reader.CanalPropertiesReader;
import com.xforceplus.ultraman.sdk.infra.metrics.MetricsDefine;
import io.micrometer.core.annotation.Timed;
import java.util.ArrayList;
import java.util.Collection;

/**
 * Created by justin.xu on 08/2022.
 *
 * @since 1.8
 */
public class EmbedDataConsumer implements SourceDataConsumer {

  private DataProcessor dataProcessor;

  private Collection<ClientIdentity> clientIdentities;

  public EmbedDataConsumer(CDCPropertyPackage cdcPropertyPackage, DataProcessor dataProcessor) {
    this.dataProcessor = dataProcessor;

    this.clientIdentities = new ArrayList<>();
    for (CanalPropertiesReader canalPropertiesReader : cdcPropertyPackage.readers()) {
      ClientIdentity clientIdentity = new ClientIdentity(
          canalPropertiesReader.getDestination(), canalPropertiesReader.getClientId(), canalPropertiesReader.getFilter());

      clientIdentities.add(clientIdentity);
    }

  }

  @Override
  public void init() {
  }

  @Override
  public void destroy() {
  }

  @Timed(
      value = MetricsDefine.PROCESS_DELAY_LATENCY_SECONDS,
      extraTags = {"initiator", "cdc", "action", "oneBatch"}
  )
  @Override
  public boolean onConsume(Message message, int threadBatchSize) throws Exception {
    if (null != message) {
      //  执行并设置当前metrics
      return dataProcessor.onProcess(message, threadBatchSize);
    }
    return false;
  }

  @Override
  public Collection<ClientIdentity> clients() {
    return this.clientIdentities;
  }
}
