package com.xforceplus.ultraman.cdc.core.remote.context;

import com.xforceplus.ultraman.cdc.dto.enums.CDCStatus;

/**
 * Created by justin.xu on 06/2023.
 *
 * @since 1.8
 */
public class RunnerContext {

    private long totalExecutedRecords;

    private int continuesConnectFails;

    private volatile RunningStatus runningStatus;

    private volatile CDCStatus cdcStatus;

    private boolean stopped = false;

    private long batchId;


    /**
     * 构造实例.
     */
    public RunnerContext() {
        this.continuesConnectFails = 0;
        this.runningStatus = RunningStatus.RUN;
        this.cdcStatus = CDCStatus.INIT;
        this.batchId = 0;
    }

    public CDCStatus getCdcStatus() {
        return cdcStatus;
    }

    public void setCdcStatus(CDCStatus cdcStatus) {
        this.cdcStatus = cdcStatus;
    }

    public void addTotalExecuteRecords(long totalExecutedRecords) {
        this.totalExecutedRecords += totalExecutedRecords;
    }

    public long totalExecutedRecords() {
        return totalExecutedRecords;
    }

    public int getContinuesConnectFails() {
        return continuesConnectFails;
    }

    public void resetContinuesConnectFails() {
        this.continuesConnectFails = 0;
    }

    public void incrementContinuesConnectFails() {
        this.continuesConnectFails++;
    }

    public RunningStatus getRunningStatus() {
        return runningStatus;
    }

    public void setRunningStatus(RunningStatus runningStatus) {
        this.runningStatus = runningStatus;
    }

    public long getBatchId() {
        return batchId;
    }

    public boolean isStopped() {
        return stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }
}
