package com.xforceplus.ultraman.cdc.utils;

/**
 * @ClassName VerifyThreadParamUtils
 * @description:
 * @author: WanYi
 * @create: 2023-09-03 17:29
 * @Version 1.0
 **/
public class VerifyThreadParamUtils {

  private final static int minThreadBatchSize = 512;
  private final static int maxThreadBatchSize = 5120;

  /**
   * @param threadBatchSize
   * @return 对threadBatchSize值做校验
   **/
  public static int getThreadBatchSize(int threadBatchSize) {
    /**threadBatchSize值校验,防止设置过大或者过小,导致同步性能慢**/
    if (threadBatchSize < minThreadBatchSize) {
      return minThreadBatchSize;
    } else if (threadBatchSize > maxThreadBatchSize) {
      return maxThreadBatchSize;
    }
    return threadBatchSize;
  }
}
