/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.cdc;

import com.alibaba.otter.canal.common.utils.NamedThreadFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.ultraman.cdc.CDCLifeCycle;
import com.xforceplus.ultraman.cdc.CDCServer;
import com.xforceplus.ultraman.cdc.core.local.EmbedCDCServer;
import com.xforceplus.ultraman.cdc.core.remote.DispatcherCDCServer;
import com.xforceplus.ultraman.cdc.dto.enums.CDCStatus;
import com.xforceplus.ultraman.cdc.lock.CDCDestinationLock;
import com.xforceplus.ultraman.cdc.processor.DataProcessor;
import com.xforceplus.ultraman.cdc.reader.CDCPropertyPackage;
import com.xforceplus.ultraman.cdc.reader.CDCPropertyPackageInternal;
import com.xforceplus.ultraman.cdc.utils.TimeWaitUtils;
import com.xforceplus.ultraman.sdk.infra.utils.JacksonDefaultMapper;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDCStarter
implements CDCLifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(CDCStarter.class);
    private CDCServer cdcServer;
    private volatile boolean isShutdown = false;
    private ScheduledExecutorService executor = null;
    private CDCDestinationLock lock = null;

    public CDCStarter(String key, CDCPropertyPackage cdcPropertyPackage, DataProcessor dataProcessor, CDCDestinationLock lock) {
        this.executor = Executors.newScheduledThreadPool(cdcPropertyPackage.readers().size(), (ThreadFactory)new NamedThreadFactory("cdc-server-metrics"));
        if (cdcPropertyPackage.model().equals((Object)CDCPropertyPackageInternal.Model.REMOTE)) {
            if (lock != null) {
                lock.run(key, () -> {
                    this.cdcServer = new DispatcherCDCServer(cdcPropertyPackage, dataProcessor);
                }, () -> {
                    this.cdcServer = new DispatcherCDCServer(cdcPropertyPackage, dataProcessor);
                    this.init();
                });
            } else {
                this.cdcServer = new DispatcherCDCServer(cdcPropertyPackage, dataProcessor);
            }
        } else if (cdcPropertyPackage.model().equals((Object)CDCPropertyPackageInternal.Model.LOCAL)) {
            if (lock != null) {
                lock.run(key, () -> {
                    this.cdcServer = new EmbedCDCServer(cdcPropertyPackage, dataProcessor);
                }, () -> {
                    this.cdcServer = new EmbedCDCServer(cdcPropertyPackage, dataProcessor);
                    this.init();
                });
            } else {
                this.cdcServer = new EmbedCDCServer(cdcPropertyPackage, dataProcessor);
            }
        }
    }

    @Override
    @PostConstruct
    public void init() {
        if (this.cdcServer != null) {
            this.cdcServer.init();
            this.isShutdown = false;
            this.cdcServer.execute();
            this.executor.submit(this::metrics);
        }
    }

    @Override
    @PreDestroy
    public void destroy() {
        if (this.cdcServer != null) {
            this.cdcServer.destroy();
            this.isShutdown = true;
            this.executor.shutdown();
        }
    }

    public CDCServer cdcServer() {
        return this.cdcServer;
    }

    private void metrics() {
        while (!this.isShutdown) {
            Map<String, CDCStatus> cdcStatusMap = this.cdcServer.metrics();
            if (null == cdcStatusMap) continue;
            try {
                logger.info("cdc status : {}", (Object)JacksonDefaultMapper.OBJECT_MAPPER.writeValueAsString(cdcStatusMap));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            TimeWaitUtils.wakeupAfter(30L, TimeUnit.SECONDS);
        }
    }
}

