/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.cdc.dto;

import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ParseResult {
    private long startId = -1L;
    private int pos = 0;
    private Map<String, OqsEngineEntity> finishEntries = new LinkedHashMap<String, OqsEngineEntity>();
    private Map<String, Error> errors = new LinkedHashMap<String, Error>();
    private Set<Long> isReadyCommitIds = new HashSet<Long>();

    public void clean() {
        this.finishEntries.clear();
        this.errors.clear();
        this.isReadyCommitIds.clear();
        this.pos = 0;
        this.startId = -1L;
    }

    public Map<String, OqsEngineEntity> getFinishEntries() {
        return this.finishEntries;
    }

    public Map<String, Error> getErrors() {
        return this.errors;
    }

    public Set<Long> isReadyCommitIds() {
        return this.isReadyCommitIds;
    }

    public int getPos() {
        return this.pos;
    }

    public void finishOne() {
        ++this.pos;
    }

    public long getStartId() {
        return this.startId;
    }

    public void setStartId(long startId) {
        this.startId = startId;
    }

    public void addError(Error error) {
        this.errors.put(error.keyGenerate(), error);
    }

    public void addError(long id, long commitId, String message) {
        this.addError(new Error(id, commitId, this.pos, "", message));
    }

    public void addError(long id, long commitId, int pos, String operationObjectString, String message) {
        this.addError(new Error(id, commitId, pos, operationObjectString, message));
    }

    public static class Error {
        private long id;
        private long commitId;
        private int pos;
        private String message;
        private String operationObjectString;

        public Error(long id, long commitId, int pos, String operationObjectString, String message) {
            this.id = id;
            this.commitId = commitId;
            this.pos = pos;
            this.operationObjectString = operationObjectString;
            this.message = message;
        }

        public long getId() {
            return this.id;
        }

        public long getCommitId() {
            return this.commitId;
        }

        public String getMessage() {
            return this.message;
        }

        public String keyGenerate() {
            return this.commitId + "_" + this.id + "_" + this.pos;
        }

        public String getOperationObjectString() {
            return this.operationObjectString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            return this.id == error.id && this.commitId == error.commitId && this.pos == error.pos && Objects.equals(this.message, error.message);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.commitId, this.pos, this.message);
        }
    }
}

