/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.cdc.utils;

import com.alibaba.otter.canal.protocol.CanalEntry;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class BinLogParseUtils {
    public static long getLongFromColumn(Map<String, CanalEntry.Column> columns, String code, Long defaultValue) {
        try {
            Long value = BinLogParseUtils.getLongFromColumn(columns, code);
            if (null == value) {
                return defaultValue;
            }
            return value;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getIntegerFromColumn(Map<String, CanalEntry.Column> columns, String code, Integer defaultValue) {
        try {
            Integer value = BinLogParseUtils.getIntegerFromColumn(columns, code);
            if (null == value) {
                return defaultValue;
            }
            return value;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getLongFromColumn(Map<String, CanalEntry.Column> columns, String code) throws SQLException {
        CanalEntry.Column column = BinLogParseUtils.getColumnWithoutNull(columns, code);
        if (null == column) {
            throw new SQLException(String.format("%s could not be null.", code));
        }
        return Long.parseLong(column.getValue());
    }

    public static long getLongFromColumn(List<CanalEntry.Column> columns, String code) throws SQLException {
        CanalEntry.Column column = BinLogParseUtils.getColumnWithoutNull(columns, code);
        if (null == column) {
            throw new SQLException(String.format("%s could not be null.", code));
        }
        return Long.parseLong(column.getValue());
    }

    public static Integer getIntegerFromColumn(Map<String, CanalEntry.Column> columns, String code) throws SQLException {
        CanalEntry.Column column = BinLogParseUtils.getColumnWithoutNull(columns, code);
        if (null == column) {
            throw new SQLException(String.format("%s could not be null.", code));
        }
        return Integer.parseInt(column.getValue());
    }

    public static String getStringFromColumn(Map<String, CanalEntry.Column> columns, String code) {
        CanalEntry.Column column = BinLogParseUtils.getColumnWithoutNull(columns, code);
        if (null == column) {
            return "";
        }
        return column.getValue();
    }

    public static Boolean getBooleanFromColumn(Map<String, CanalEntry.Column> columns, String code) {
        CanalEntry.Column column = BinLogParseUtils.getColumnWithoutNull(columns, code);
        if (null == column) {
            return null;
        }
        return BinLogParseUtils.stringToBoolean(column.getValue());
    }

    public static boolean stringToBoolean(String str) {
        return str.equalsIgnoreCase("true") || StringUtils.isNumeric((CharSequence)str) && Integer.parseInt(str) > 0;
    }

    public static CanalEntry.Column getColumnWithoutNull(Map<String, CanalEntry.Column> columns, String code) {
        return columns.containsKey(code) ? columns.get(code) : null;
    }

    public static CanalEntry.Column getColumnWithoutNull(List<CanalEntry.Column> columns, String code) {
        Optional<CanalEntry.Column> first = columns.stream().filter(column -> StringUtils.equalsIgnoreCase((CharSequence)column.getName(), (CharSequence)code)).findFirst();
        return first.isPresent() ? first.get() : null;
    }
}

