package com.xforceplus.ultraman.cdc.adapter.impl;

import com.xforceplus.ultraman.cdc.adapter.CDCFilter;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;

import java.util.List;
import java.util.Optional;

/**
 * an important type based cdcFilter
 */
public class TypeBasedCDCFilter implements CDCFilter {

    private CdcConfig configs;

    private EntityClassEngine engine;

    public TypeBasedCDCFilter(EntityClassEngine engine, CdcConfig configs) {
        this.configs = configs;
        this.engine = engine;
    }

    @Override
    public boolean isDoIndexSync(OqsEngineEntity oqsEngineEntity) {
        List<String> includes = configs.getInclude();
        if (includes != null && !includes.isEmpty()) {
            Optional<IEntityClass> load = engine.load(Long.toString(oqsEngineEntity.getId()), "");
            if (load.isPresent()) {
                IEntityClass entityClass = load.get();
                return includes.stream().anyMatch(x -> entityClass.code().equalsIgnoreCase(x));
            }
        }

        List<String> excludes = configs.getExclude();
        if (excludes != null && !excludes.isEmpty()) {
            Optional<IEntityClass> load = engine.load(Long.toString(oqsEngineEntity.getId()), "");
            if (load.isPresent()) {
                IEntityClass entityClass = load.get();
                return excludes.stream().allMatch(x -> !entityClass.code().equalsIgnoreCase(x));
            }
        }

        return true;
    }
}
