package com.xforceplus.ultraman.oqsengine.pojo.auth;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

/**
 * 授权信息.
 * @version 0.1 2020/2/13 15:30
 * @author wangzheng
 * @since 1.8
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class Authorization implements Serializable {
    /**
     * 应用id
     */
    private Long appId;
    /**
     * 用户角色id
     */
    private String role;
    /**
     * 租户id
     */
    private Long tenantId;
    /**
     * 环境id
     */
    private String env;

    private String appCode;

    private String branch;

    /**
     * 默认构造方法
     */
    public Authorization() {
    }


    public Authorization(Long appId, String role, Long tenantId, String env, String appcode, String branch) {
        this.appId = appId;
        this.role = role;
        this.tenantId = tenantId;
        this.env = env;
        this.appCode = appcode;
        this.branch = branch;
    }

    /**
     * 传入app,role,tenantid,env信息的构造方法
     * @param appId
     * @param role
     * @param tenantId
     * @param env
     */
    public Authorization(Long appId, String role, Long tenantId, String env) {
        this.appId = appId;
        this.role = role;
        this.tenantId = tenantId;
        this.env = env;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getEnv() {
        return env;
    }

    public void setEnv(String env) {
        this.env = env;
    }


    public String getBranch() {
        return branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getAppCode() {
        return appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Authorization that = (Authorization) o;
        return Objects.equals(appId, that.appId) &&
                Objects.equals(role, that.role) &&
                Objects.equals(tenantId, that.tenantId) &&
                Objects.equals(env, that.env) &&
                Objects.equals(appCode, that.appCode) &&
                Objects.equals(branch, that.branch);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, role, tenantId, env, appCode, branch);
    }
}
