package com.xforceplus.ultraman.oqsengine.pojo.dto.entity;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

/**
 * 字段配置信息.
 * @author dongbin
 * @version 0.1 2020/2/26 14:32
 * @since 1.8
 */
@JsonInclude(JsonInclude.Include.NON_ABSENT)
public class FieldConfig implements Serializable, Cloneable {

    /**
     * 是否可搜索.true 可搜索,false 不可搜索.
     */
    private boolean searchable = false;

    /**
     * 字符串:     最大字符个数.
     * 数字:       最大的数字.
     * 日期/时间:   离现在最近的时间日期.
     */
    private long max = Long.MAX_VALUE;

    /**
     * 字符串:     最小字符个数.
     * 数字:       最小的数字.
     * 日期/时间:   离现在最远的时间日期.
     */
    private long min = Long.MIN_VALUE;

    /**
     * 字段精度
     */
    private int precision = 0;

    /**
     * 是否为数据标识.
     */
    private boolean identifie = false;

    private boolean isRequired = false;

    private String validateRegexString = "";

    private boolean isSplittable = false;

    private String delimiter = "";

    private String displayType = "";

    private String uniqueName = "";

    private boolean isSystem = false;

    /**
     * 创建一个新的 FieldConfig.
     * @return 实例.
     */
    public static FieldConfig build() {
        return new FieldConfig();
    }

    public FieldConfig precision(int precision) {
        this.precision = precision;
        return this;
    }

    /**
     * 设置是否可搜索,默认不搜索.
     * @param searchable true 可搜索, false 不可搜索.
     * @return 当前实例.
     */
    public FieldConfig searchable(boolean searchable) {
        this.searchable = searchable;
        return this;
    }

    /**
     * 字符串:     最大字符个数.
     * 数字:       最大的数字.
     * 日期/时间:   离现在最近的时间日期.
     *
     * @param max 值.
     * @return 当前实例.
     */
    public FieldConfig max(long max) {
        this.max = max;
        return this;
    }

    /**
     * 字符串:     最小字符个数.
     * 数字:       最小的数字.
     * 日期/时间:   离现在最远的时间日期.
     *
     * @param min 值.
     * @return 当前实例.
     */
    public FieldConfig min(long min) {
        this.min = min;
        return this;
    }

    public FieldConfig identifie(boolean identifie) {
        this.identifie = identifie;
        return this;
    }

    public FieldConfig uniqueName(String uniqueName){
        this.uniqueName = uniqueName;
        return this;
    }

    public String uniqueName(){
        return this.uniqueName;
    }

    /**
     * 是否表示一个数据标识.
     * @return true 数据标识,false 非数据标识.
     */
    public boolean isIdentifie() {
        return identifie;
    }

    /**
     * 是否可搜索.true 可搜索,false 不可搜索.
     * @return 结果.
     */
    public boolean isSearchable() {
        return searchable;
    }

    /**
     * 获取最大值.
     * @return 最大值.
     */
    public long getMax() {
        return max;
    }

    /**
     * 获取最小值.
     * @return
     */
    public long getMin() {
        return min;
    }

    public int getPrecision() {
        return precision;
    }

    public String getDisplayType(){
        return this.displayType;
    }

    public FieldConfig displayType(String displayType){
        this.displayType = displayType;
        return this;
    }

    public boolean isRequired() {
        return isRequired;
    }

    public FieldConfig required(boolean required) {
        isRequired = required;
        return this;
    }

    public String getValidateRegexString() {
        return validateRegexString;
    }

    public FieldConfig validateRegexString(String validateRegexString) {
        this.validateRegexString = validateRegexString;
        return this;
    }



    public boolean isSplittable() {
        return isSplittable;
    }

    public FieldConfig splittable(boolean splittable) {

        isSplittable = splittable;
        return this;
    }

    public String getDelimiter() {
        return delimiter;
    }

    public FieldConfig delimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public FieldConfig isSystem(boolean isSystem){
        this.isSystem = isSystem;
        return this;
    }

    public String getUniqueName() {
        return uniqueName;
    }

    public boolean isSystem() {
        return isSystem;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FieldConfig that = (FieldConfig) o;
        return searchable == that.searchable &&
                max == that.max &&
                min == that.min &&
                precision == that.precision &&
                identifie == that.identifie &&
                isRequired == that.isRequired &&
                isSplittable == that.isSplittable &&
                isSystem == that.isSystem &&
                Objects.equals(validateRegexString, that.validateRegexString) &&
                Objects.equals(delimiter, that.delimiter) &&
                Objects.equals(displayType, that.displayType) &&
                Objects.equals(uniqueName, that.uniqueName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(searchable, max, min, precision, identifie, isRequired, validateRegexString, isSplittable, delimiter, displayType, uniqueName, isSystem);
    }

    @Override
    public String toString() {
        return "FieldConfig{" +
                "searchable=" + searchable +
                ", max=" + max +
                ", min=" + min +
                ", precision=" + precision +
                ", identifie=" + identifie +
                ", isRequired=" + isRequired +
                ", validateRegexString='" + validateRegexString + '\'' +
                ", isSplittable=" + isSplittable +
                ", delimiter='" + delimiter + '\'' +
                ", displayType='" + displayType + '\'' +
                ", uniqueName='" + uniqueName + '\'' +
                ", isSystem=" + isSystem +
                '}';
    }


    @Override
    public FieldConfig clone() {
        FieldConfig fieldConfig = new FieldConfig();
        fieldConfig.isSystem(isSystem);
        fieldConfig.validateRegexString(validateRegexString);
        fieldConfig.searchable(searchable);
        fieldConfig.identifie(identifie);
        fieldConfig.uniqueName(uniqueName);
        fieldConfig.delimiter(delimiter);
        fieldConfig.splittable(isSplittable);
        fieldConfig.displayType(displayType);
        fieldConfig.required(isRequired);
        fieldConfig.precision(precision);
        fieldConfig.max(max);
        fieldConfig.min(min);

        return fieldConfig;
    }
}
