package com.xforceplus.ultraman.oqsengine.pojo.dto.serachconfig;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions;
import com.xforceplus.ultraman.oqsengine.pojo.dto.sort.Sort;
import com.xforceplus.ultraman.oqsengine.pojo.page.Page;

/**
 * 搜索配置.
 * 默认如果不设置将使用如下默认值.
 * 分页: 第1页的,页大小为10.
 * 排序: 不排序.
 * 数据访问控制条件: 没有控制.
 *
 * @author dongbin
 * @version 0.1 2020/8/21 15:56
 * @since 1.8
 */
public class SearchConfig {

    private Page page;
    private Sort sort;

    public SearchConfig() {
        this(null, null);
    }

    public SearchConfig(Page page) {
        this(page, null);
    }

    public SearchConfig(Page page, Sort sort) {
        this.page = page;
        this.sort = sort;

        if (this.page == null) {
            this.page = new Page(1, 10);
        }

        if (sort == null) {
            this.sort = Sort.buildOutOfSort();
        }
    }

    public Page getPage() {
        return page;
    }

    public Sort getSort() {
        return sort;
    }
}
