package com.xforceplus.ultraman.oqsengine.pojo.reader.record;

import com.xforceplus.ultraman.bocp.gen.typed.TypedField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.reader.converter.LocalDateTimeConverter;
import io.vavr.Tuple2;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.PropertyUtils;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

/**
 *
 */
public interface Record extends Comparable<Record>  {

    Long getParentId();
    /**
     * always has a id;
     * @return
     */
    Long getId();

    Long getTypeId();

    void setTypeId(Long typeId);

    void setId(Long id);

    void setParentId(Long id);

    Optional<Object> get(String fieldName);

    Object get(int index);

    Optional<Object> get(IEntityField field);

    Optional<IValue> getTypedValue(String fieldName);

    Optional<IValue> getTypedValue(IEntityField field);

    <T> Optional<T> get(String fieldName, Class<? extends T> type);

    <T> Optional<T> get(IEntityField field, Class<? extends T> type);

    <T> Optional<T> get(TypedField<T> typedField);

    <T> void set(TypedField<T> typedField, T t);

    void set(String fieldName, Object t);

    void set(IEntityField field, Object t);

    void fromMap(Map<String, Object> map);

    void setTypedValue(IValue iValue);

    /**
     * to a pojo
     * @param targetClass
     * @param <T>
     * @return
     */
    <T> T into(Class<T> targetClass);

    Stream<Tuple2<IEntityField, Object>> stream();

    /**
     * filter the input key
     * @param keys filter keys;
     * @return
     */
    Stream<Tuple2<IEntityField, Object>> stream(Set<String> keys);

    Stream<Tuple2<IEntityField, Object>> stream(List<String> orderedKeys);

    Map<String, Object> toMap(Set<String> keys);

    Map<String, Object> toNestedMap(Set<String> keys);

    Boolean isEmpty();

    Boolean nonEmpty();

    Integer version();

}
