package com.xforceplus.ultraman.oqsengine.pojo.utils;

import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.reader.converter.LocalDateTimeConverter;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;

import java.math.BigDecimal;
import java.time.LocalDateTime;

public class ConvertHelper {

    public static final BeanUtilsBean bean = BeanUtilsBean.getInstance();

    static {
        bean.getPropertyUtils().addBeanIntrospector(new FluentPropertyBeanIntrospector());
        bean.getConvertUtils().register(new LocalDateTimeConverter(), LocalDateTime.class);
    }

    public static String convert(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LocalDateTime) {
            return Long.toString(new DateTimeValue(null, (LocalDateTime) obj).valueToLong());
        } else if (obj instanceof BigDecimal) {
            return ((BigDecimal) obj).toPlainString();
        } else {
            return ConvertHelper.bean.getConvertUtils().convert(obj);
        }
    }
}
