package com.xforceplus.ultraman.oqsengine.pojo.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;

/**
 * pretty print to show yaml
 */
public class PrettyPrinter {

    private final static ObjectMapper objectMapper = new ObjectMapper(new YAMLFactory());

    public static String print(Object obj){
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }
}