/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.utils;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.pojo.utils.OptionalHelper;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;

public class PropertyHelper {
    public static final String REL_PREFIX = "_";
    public static final String REL_DELIMITER = ".";
    public static final String TYPE_REL_DELIMITER = "$";
    private static final char CASE_DELIMITER = '_';

    public static String generateRelatedFieldName(String code, String fieldName) {
        StringBuffer sb = new StringBuffer();
        sb.append(REL_PREFIX);
        sb.append(code);
        sb.append(REL_DELIMITER);
        sb.append(fieldName);
        return sb.toString();
    }

    public static Tuple2<String, String> extractRelated(String name) {
        String[] nameArray;
        if (name.startsWith(REL_PREFIX) && (nameArray = name.split("\\.")).length > 1) {
            return Tuple.of((Object)nameArray[0].substring(1), (Object)nameArray[1]);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String camelToBoProperty(String camelCase, boolean toSnake) {
        String propertyStr = camelCase.replaceAll("\\$", REL_DELIMITER);
        String fieldName = "";
        if (propertyStr.contains(REL_DELIMITER)) {
            String[] split = propertyStr.split("\\.");
            if (split.length <= 1) throw new RuntimeException("length error");
            String relationCode = split[0];
            if (!toSnake) return PropertyHelper.generateRelatedFieldName(relationCode, split[1]);
            return PropertyHelper.generateRelatedFieldName(relationCode, PropertyHelper.camelCaseToUnderscore(split[1]));
        }
        if (!toSnake) return propertyStr;
        return PropertyHelper.camelCaseToUnderscore(propertyStr);
    }

    private static String camelCaseToUnderscore(String camelCase) {
        Object[] camelCaseParts = StringUtils.splitByCharacterTypeCamelCase((String)camelCase);
        for (int i = 0; i < camelCaseParts.length; ++i) {
            camelCaseParts[i] = ((String)camelCaseParts[i]).toLowerCase(Locale.ENGLISH);
        }
        return StringUtils.join((Object[])camelCaseParts, (String)REL_PREFIX);
    }

    private static boolean isSnake(String snake) {
        return snake.indexOf(95) > 1;
    }

    public static Optional<String> getColumnName(IEntityClassReader reader, String key) {
        String camelCase;
        String snakeCase;
        if (PropertyHelper.isSnake(key)) {
            snakeCase = key;
            camelCase = PropertyHelper.convertToCamel(key);
        } else {
            snakeCase = PropertyHelper.camelToBoProperty(key, true);
            camelCase = PropertyHelper.convertToCamel(key);
        }
        Optional<ColumnField> columnSnake = reader.column(snakeCase);
        Optional<ColumnField> columnCamel = reader.column(camelCase);
        Optional<ColumnField> combine = OptionalHelper.combine(columnCamel, columnSnake);
        return combine.map(ColumnField::name);
    }

    public static String convertToCamel(String input) {
        String s = null;
        if (input.contains(REL_DELIMITER)) {
            String[] split = input.split("\\.");
            if (split.length > 1) {
                String code = split[0];
                String field = PropertyHelper.convertToProperty(split[1]);
                s = code.concat(TYPE_REL_DELIMITER).concat(field);
            }
        } else {
            s = PropertyHelper.convertToProperty(input);
        }
        return s;
    }

    private static String convertToProperty(String keyName) {
        if (keyName.contains(String.valueOf('_'))) {
            return CaseUtils.toCamelCase((String)keyName, (boolean)false, (char[])new char[]{'_'});
        }
        return keyName;
    }
}

