/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.BooleanValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DecimalValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EnumValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringsValue;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FieldType {
    UNKNOWN("Unknown", s -> false, StringValue::new),
    BOOLEAN("Boolean", Boolean.class, s -> {
        try {
            Boolean.parseBoolean(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }, new String[]{"boolean"}, (f, v) -> new BooleanValue((IEntityField)f, Boolean.parseBoolean(v)), (v1, v2) -> {
        Boolean value1 = (Boolean)((BooleanValue)v1).getValue();
        Boolean value2 = (Boolean)((BooleanValue)v2).getValue();
        return Boolean.compare(value1, value2);
    }),
    ENUM("Enum", new String[]{"enum"}, EnumValue::new),
    DATETIME("DateTime", Long.class, s -> {
        try {
            Instant.ofEpochMilli(Long.parseLong(s));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }, new String[]{"timestamp"}, (f, v) -> {
        Instant instant = Instant.ofEpochMilli(Long.parseLong(v));
        return new DateTimeValue((IEntityField)f, LocalDateTime.ofInstant(instant, DateTimeValue.zoneId));
    }, (v1, v2) -> {
        LocalDateTime value1 = (LocalDateTime)((DateTimeValue)v1).getValue();
        LocalDateTime value2 = (LocalDateTime)((DateTimeValue)v2).getValue();
        return value1.compareTo(value2);
    }),
    LONG("Long", Long.class, s -> {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }, new String[]{"bigint", "long", "serialNo"}, (f, v) -> new LongValue((IEntityField)f, Long.parseLong(v)), (v1, v2) -> {
        Long value1 = (Long)((LongValue)v1).getValue();
        Long value2 = (Long)((LongValue)v2).getValue();
        return Long.compare(value1, value2);
    }),
    STRING("String", new String[]{"string"}, StringValue::new),
    STRINGS("Strings", String.class, s -> {
        try {
            s.trim().split(",");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }, new String[]{"strings", "enums"}, (x, str) -> new StringsValue((IEntityField)x, str.trim().split(",")), (v1, v2) -> 0),
    DECIMAL("Decimal", BigDecimal.class, s -> {
        try {
            new BigDecimal((String)s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }, new String[]{"double", "decimal"}, (f, v) -> {
        int precision = Optional.ofNullable(f.config()).map(FieldConfig::getPrecision).filter(x -> x > 0).orElse(2);
        return new DecimalValue((IEntityField)f, new BigDecimal((String)v).setScale(precision, RoundingMode.HALF_UP));
    }, (v1, v2) -> {
        BigDecimal value1 = (BigDecimal)((DecimalValue)v1).getValue();
        BigDecimal value2 = (BigDecimal)((DecimalValue)v2).getValue();
        return value1.compareTo(value2);
    });

    private String type;
    private Predicate<String> tester;
    private String[] accepts;
    private Class javaType;
    private BiFunction<IEntityField, String, IValue> iValueConverter;
    private BiFunction<IValue, IValue, Integer> comparator;
    private Logger logger = LoggerFactory.getLogger(FieldType.class);

    private FieldType(String type, Class javaType, Predicate<String> tester, String[] accepts, BiFunction<IEntityField, String, IValue> iValueConverter, BiFunction<IValue, IValue, Integer> comparator) {
        this.type = type;
        this.tester = tester;
        this.accepts = accepts;
        this.iValueConverter = iValueConverter;
        this.javaType = javaType;
        this.comparator = comparator;
    }

    private FieldType(String type, Predicate<String> tester, BiFunction<IEntityField, String, IValue> iValueConverter) {
        this(type, String.class, tester, new String[0], iValueConverter, (v1, v2) -> v1.valueToString().compareTo(v2.valueToString()));
    }

    private FieldType(String type, String[] accepts, BiFunction<IEntityField, String, IValue> iValueConverter) {
        this(type, String.class, s -> true, accepts, iValueConverter, (v1, v2) -> v1.valueToString().compareTo(v2.valueToString()));
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean canParseFrom(String input) {
        return this.tester.test(input);
    }

    public int compare(String o1, String o2) {
        if (this.comparator == null) {
            return 0;
        }
        EntityField field = new EntityField(-1L, "dummy", this);
        IValue ivalueA = this.iValueConverter.apply(field, o1);
        IValue ivalueB = this.iValueConverter.apply(field, o2);
        return this.comparator.apply(ivalueA, ivalueB);
    }

    public Optional<IValue> toTypedValue(IEntityField entityField, String value) {
        Objects.requireNonNull(value, "value\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(entityField, "field\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.tester.test(value)) {
            return Optional.ofNullable(this.iValueConverter.apply(entityField, value));
        }
        this.logger.error("Value '{}' failed to turn to type {} on Field {}:{}", new Object[]{value, this, entityField.name(), entityField.id()});
        return Optional.empty();
    }

    public boolean accept(String rawType) {
        return Stream.of(this.accepts).anyMatch(x -> x.equalsIgnoreCase(rawType));
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public static FieldType fromRawType(String rawType) {
        try {
            return FieldType.valueOf(rawType.toUpperCase());
        }
        catch (Exception exception) {
            return Stream.of(FieldType.values()).filter(x -> x.accept(rawType)).findFirst().orElse(STRING);
        }
    }
}

