/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityFamily;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityFamily;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class Entity
implements IEntity,
Serializable {
    private static final IEntityFamily EMPTY_FAMILY = new EntityFamily(0L, 0L);
    private long id;
    private long time;
    private IEntityClass entityClass;
    private long realEntity;
    private IEntityValue entityValue;
    private IEntityFamily family = EMPTY_FAMILY;
    private int version;
    private long maintainid;
    private int major;

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public IEntityClass entityClass() {
        return this.entityClass;
    }

    @Override
    public IEntityValue entityValue() {
        return this.entityValue;
    }

    @Override
    public void resetEntityValue(IEntityValue iEntityValue) {
        this.entityValue = iEntityValue;
    }

    @Override
    public IEntityFamily family() {
        return this.family;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public void resetVersion(int version) {
        this.version = version;
    }

    @Override
    public long time() {
        return this.time;
    }

    @Override
    public void markTime(long time) {
        this.time = time;
    }

    @Override
    public long maintainId() {
        return this.maintainid;
    }

    @Override
    public void markTime() {
        this.time = System.currentTimeMillis();
    }

    @Override
    public int major() {
        return this.major;
    }

    public Entity(long id, IEntityClass entityClass, IEntityValue entityValue) {
        this(id, entityClass, entityValue, null, 0, 1);
    }

    public Entity(long id, IEntityClass entityClass, IEntityValue entityValue, int major) {
        this(id, entityClass, entityValue, null, 0, major);
    }

    public Entity(long id, IEntityClass entityClass, IEntityValue entityValue, int version, int major) {
        this(id, entityClass, entityValue, null, version, major);
    }

    public Entity(long id, IEntityClass entityClass, IEntityValue entityValue, IEntityFamily family, int version, int major) {
        if (entityClass == null) {
            throw new IllegalArgumentException("Invalid class meta information.");
        }
        if (entityValue == null) {
            throw new IllegalArgumentException("Invalid attribute value.");
        }
        this.id = id;
        this.entityClass = entityClass;
        this.entityValue = entityValue;
        if (family != null) {
            this.family = family;
        }
        this.version = version;
        this.major = major;
    }

    @Override
    public void resetId(long id) {
        this.id = id;
        this.entityValue.restId(id);
    }

    @Override
    public long realEntity() {
        return this.realEntity;
    }

    @Override
    public void resetRealEntity(long realEntity) {
        this.realEntity = realEntity;
    }

    @Override
    public void resetFamily(IEntityFamily family) {
        this.family = family;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Entity newEntity = new Entity(this.id(), this.entityClass(), (IEntityValue)this.entityValue().clone(), this.family(), this.version(), 1);
        newEntity.markTime(this.time());
        return newEntity;
    }

    @Override
    public void restMaintainId(long maintainId) {
        this.maintainid = maintainId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)o;
        if (this.id != entity.id) {
            return false;
        }
        if (this.version != entity.version) {
            return false;
        }
        if (this.time != entity.time) {
            return false;
        }
        if (this.major != entity.major) {
            return false;
        }
        if (!this.entityClass.equals(entity.entityClass)) {
            return false;
        }
        if (!this.entityValue.equals(entity.entityValue)) {
            return false;
        }
        return this.family.equals(entity.family);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.time, this.entityClass, this.entityValue, this.family, this.version, this.major);
    }

    public String toString() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        StringBuilder buff = new StringBuilder();
        buff.append("id: ").append(this.id).append(", ").append("entity: ").append(this.entityClass.code()).append(", ").append("version: ").append(this.version).append(", ").append("time: ").append(df.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(this.time), ZoneId.systemDefault()))).append(", ").append("major: ").append(this.major).append(", ").append("pref: ").append(this.family.parent()).append(", ").append("cref: ").append(this.family.child()).append("\n");
        this.entityValue().values().stream().forEach(v -> buff.append("{").append("id: ").append(v.getField().id()).append(", ").append("name: ").append(v.getField().name()).append(", ").append("type: ").append(v.getField().type().getType()).append(", ").append("value: ").append(v.getValue().toString()).append("}\n"));
        return buff.toString();
    }
}

