/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.values;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.AbstractValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Objects;

public class DateTimeValue
extends AbstractValue<LocalDateTime> {
    public static final ZoneId zoneId = ZoneId.of("Asia/Shanghai");

    public DateTimeValue(IEntityField field, LocalDateTime value) {
        super(field, value);
    }

    @Override
    public long valueToLong() {
        Instant instant = ((LocalDateTime)this.getValue()).atZone(zoneId).toInstant();
        return instant.toEpochMilli();
    }

    public int hashCode() {
        return Objects.hash(this.getField(), this.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateTimeValue)) {
            return false;
        }
        DateTimeValue that = (DateTimeValue)o;
        return Objects.equals(this.getField(), that.getField()) && Objects.equals(this.getValue(), that.getValue());
    }

    @Override
    public IValue<LocalDateTime> shallowClone() {
        return new DateTimeValue(this.getField(), (LocalDateTime)this.getValue());
    }

    @Override
    public boolean compareByString() {
        return false;
    }

    public String toString() {
        return "DateTimeValue{field=" + this.getField() + ", value=" + this.getValue() + '}';
    }
}

