/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.converter;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Condition;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ValueConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.AliasField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Entity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Wrapped;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.EmptyValue;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.pojo.utils.ConvertHelper;
import com.xforceplus.ultraman.oqsengine.pojo.utils.OptionalHelper;
import com.xforceplus.ultraman.oqsengine.sdk.ConditionsUp;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldConditionUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldSortUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldUp;
import com.xforceplus.ultraman.oqsengine.sdk.RelationUp;
import com.xforceplus.ultraman.oqsengine.sdk.ValueUp;
import io.vavr.API;
import io.vavr.Predicates;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IEntityClassHelper {
    private static Logger logger = LoggerFactory.getLogger(IEntityClassHelper.class);

    public static IEntityField toEntityField(FieldUp fieldUp) {
        return new EntityField(fieldUp.getId(), fieldUp.getCode(), fieldUp.getName(), FieldType.valueOf(fieldUp.getFieldType()), FieldConfig.build().searchable(OptionalHelper.ofEmptyStr(fieldUp.getSearchable()).map(Boolean::valueOf).orElse(false)).max(OptionalHelper.ofEmptyStr(fieldUp.getMaxLength()).map(String::valueOf).map(Long::parseLong).orElse(-1L)).min(OptionalHelper.ofEmptyStr(fieldUp.getMinLength()).map(String::valueOf).map(Long::parseLong).orElse(-1L)).precision(fieldUp.getPrecision()).identifie(fieldUp.getIdentifier()).isSystem(fieldUp.getIsSystem()).required("true".equals(fieldUp.getRequired())), fieldUp.getDictId(), fieldUp.hasField(FieldUp.getDescriptor().findFieldByNumber(13)) ? fieldUp.getDefaultValue() : null);
    }

    public static Relation toEntityRelation(RelationUp relationUp) {
        return new Relation(relationUp.getName(), relationUp.getRelatedEntityClassId(), relationUp.getRelationType(), relationUp.getIdentity(), relationUp.hasEntityField() ? IEntityClassHelper.toEntityField(relationUp.getEntityField()) : null);
    }

    public static IEntityClass getSubEntityClass(EntityUp entityUp) {
        boolean hasSubClass = entityUp.hasField(EntityUp.getDescriptor().findFieldByNumber(9));
        if (hasSubClass) {
            return IEntityClassHelper.toEntityClass(entityUp.getSubEntityClass());
        }
        return null;
    }

    public static IEntityClass toEntityClass(EntityUp entityUp) {
        boolean hasExtendedClass = entityUp.hasField(EntityUp.getDescriptor().findFieldByNumber(4));
        EntityClass entityClass = new EntityClass(entityUp.getId(), Long.valueOf(entityUp.getVersion()).intValue(), entityUp.getCode(), entityUp.getRelationList().stream().map(IEntityClassHelper::toEntityRelation).collect(Collectors.toList()), entityUp.getEntityClassesList().stream().map(relatedEntityUp -> {
            boolean hasParent = relatedEntityUp.hasField(EntityUp.getDescriptor().findFieldByNumber(4));
            if (hasParent) {
                IEntityClass parent = IEntityClassHelper.toRawEntityClass(relatedEntityUp.getExtendEntityClass());
                return IEntityClassHelper.toRawEntityClass(relatedEntityUp, parent);
            }
            return IEntityClassHelper.toRawEntityClass(relatedEntityUp);
        }).collect(Collectors.toList()), hasExtendedClass ? IEntityClassHelper.toRawEntityClass(entityUp.getExtendEntityClass()) : null, Collections.emptyList(), (Collection<IEntityField>)entityUp.getFieldsList().stream().map(IEntityClassHelper::toEntityField).collect(Collectors.toList()));
        List<IEntityClass> children = entityUp.getNarrowEntityClassesList().stream().map(x -> IEntityClassHelper.toRawEntityClass(x, entityClass)).collect(Collectors.toList());
        entityClass.resetChildEntityClass(children);
        return entityClass;
    }

    public static List<IValue> toTypedValue(IEntityField entityField, String value) {
        if (value != null && EmptyValue.isEmpty(value)) {
            return Collections.singletonList(new EmptyTypedValue(entityField));
        }
        return entityField.type().toTypedValue(entityField, value).map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    public static IEntityClass toRawEntityClass(EntityUp entityUp) {
        return IEntityClassHelper.toRawEntityClass(entityUp, null);
    }

    public static IEntityClass toRawEntityClass(EntityUp entityUp, IEntityClass parent) {
        return new EntityClass(entityUp.getId(), (int)Optional.ofNullable(entityUp.getVersion()).map(x -> Long.valueOf(x).intValue()).orElse(-1), entityUp.getCode(), null, Collections.emptyList(), parent, Collections.emptyList(), (Collection<IEntityField>)entityUp.getFieldsList().stream().map(IEntityClassHelper::toEntityField).collect(Collectors.toList()));
    }

    public static Optional<Conditions> toConditions(IEntityClass mainClass, IEntityClassReader reader, ConditionsUp conditionsUp, List<Long> ids) {
        Optional<Conditions> conditions = conditionsUp.getFieldsList().stream().map(x -> {
            Optional<AliasField> field = reader.field(x.getField().getId());
            return IEntityClassHelper.toOneConditions(field.map(AliasField::getOriginObject).map(f -> (ColumnField)f), x, mainClass);
        }).filter(Objects::nonNull).reduce((a, b) -> a.addAnd((Conditions)b, true));
        if (ids != null && !ids.isEmpty()) {
            Optional<IEntityField> idField = reader.column("id").map(ColumnField::getOriginObject);
            Optional<Conditions> conditionsIds = idField.map(field -> new Conditions(new Condition((IEntityField)field, ConditionOperator.MULTIPLE_EQUALS, (IValue[])ids.stream().map(x -> new LongValue((IEntityField)field, (long)x)).toArray(IValue[]::new))));
            if (conditions.isPresent()) {
                if (conditionsIds.isPresent()) {
                    return conditions.map(x -> x.addAnd((Conditions)conditionsIds.get(), true));
                }
            } else {
                return conditionsIds;
            }
        }
        return conditions;
    }

    public static IEntityValue toEntityValue(IEntityClassReader reader, EntityUp entityUp) {
        List<IValue> valueList = entityUp.getValuesList().stream().flatMap(y -> {
            Optional<IEntityField> entityFieldOp = reader.field(y.getFieldId()).map(Wrapped::getOrigin);
            return entityFieldOp.map(x -> IEntityClassHelper.toTypedValue(x, y.getValue())).orElseGet(Collections::emptyList).stream();
        }).filter(Objects::nonNull).collect(Collectors.toList());
        EntityValue entityValue = new EntityValue(entityUp.getId());
        entityValue.addValues(valueList);
        return entityValue;
    }

    public static Conditions toOneConditions(Optional<ColumnField> fieldOp, FieldConditionUp fieldCondition, IEntityClass mainClass) {
        Conditions conditions = null;
        if (fieldOp.isPresent()) {
            ColumnField columnField;
            FieldConditionUp.Op op = fieldCondition.getOperation();
            ColumnField originField = columnField = fieldOp.get();
            List nonNullValueList = fieldCondition.getValuesList().stream().filter(Objects::nonNull).collect(Collectors.toList());
            if (nonNullValueList.isEmpty()) {
                throw new RuntimeException("Field " + columnField + " Value is Missing");
            }
            switch (op) {
                case eq: {
                    conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case ne: {
                    conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.NOT_EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case ge: {
                    conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN_EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case gt: {
                    conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case ge_le: {
                    if (nonNullValueList.size() > 1) {
                        String leftValue = (String)nonNullValueList.get(0);
                        String rightValue = (String)nonNullValueList.get(1);
                        Condition left = null;
                        Condition right = null;
                        if (!StringUtils.isEmpty((CharSequence)leftValue)) {
                            left = new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN_EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0]));
                        }
                        if (!StringUtils.isEmpty((CharSequence)rightValue)) {
                            right = new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LESS_THAN_EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(1)).toArray(new IValue[0]));
                        }
                        if (left == null && right == null) {
                            conditions = null;
                            break;
                        }
                        if (left == null) {
                            conditions = new Conditions(right);
                            break;
                        }
                        if (right == null) {
                            conditions = new Conditions(left);
                            break;
                        }
                        conditions = new Conditions(left).addAnd(right);
                        break;
                    }
                    logger.warn("required value more then 1, fallback to ge");
                    conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN_EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case gt_le: {
                    if (nonNullValueList.size() > 1) {
                        String leftValue = (String)nonNullValueList.get(0);
                        String rightValue = (String)nonNullValueList.get(1);
                        Condition left = null;
                        Condition right = null;
                        if (!StringUtils.isEmpty((CharSequence)leftValue)) {
                            left = new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0]));
                        }
                        if (!StringUtils.isEmpty((CharSequence)rightValue)) {
                            right = new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LESS_THAN_EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(1)).toArray(new IValue[0]));
                            conditions = new Conditions(left).addAnd(right);
                        }
                        if (left == null && right == null) {
                            conditions = null;
                            break;
                        }
                        if (left == null) {
                            conditions = new Conditions(right);
                            break;
                        }
                        if (right == null) {
                            conditions = new Conditions(left);
                            break;
                        }
                        conditions = new Conditions(left).addAnd(right);
                        break;
                    }
                    logger.warn("required value more then 1, fallback to gt");
                    conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case ge_lt: {
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN_EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0]));
                        Condition right = new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LESS_THAN, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(1)).toArray(new IValue[0]));
                        conditions = new Conditions(left).addAnd(right);
                        break;
                    }
                    logger.warn("required value more then 2, fallback to ge");
                    conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN_EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case gt_lt: {
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0]));
                        Condition right = new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LESS_THAN, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(1)).toArray(new IValue[0]));
                        conditions = new Conditions(left).addAnd(right);
                        break;
                    }
                    logger.warn("required value more then 2, fallback to ge");
                    conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN_EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case le: {
                    conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LESS_THAN_EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case lt: {
                    conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LESS_THAN, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case in: {
                    conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.MULTIPLE_EQUALS, (IValue[])nonNullValueList.stream().flatMap(x -> IEntityClassHelper.toTypedValue((IEntityField)fieldOp.get(), x).stream()).toArray(IValue[]::new)));
                    break;
                }
                case ni: {
                    if (nonNullValueList.size() == 1) {
                        conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.NOT_EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                        break;
                    }
                    Conditions finalConditions = conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.NOT_EQUALS, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    nonNullValueList.stream().skip(1L).forEach(x -> finalConditions.addAnd(new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.NOT_EQUALS, IEntityClassHelper.toTypedValue((IEntityField)fieldOp.get(), x).toArray(new IValue[0]))), false));
                    conditions = finalConditions;
                    break;
                }
                case like: {
                    conditions = new Conditions(new Condition(IEntityClassHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LIKE, IEntityClassHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
            }
        }
        if (conditions == null) {
            throw new RuntimeException("Condition is invalid " + fieldCondition);
        }
        return conditions;
    }

    public static boolean isRelatedField(ColumnField columnField, IEntityClass mainClass) {
        IEntityClass entityClass = columnField.originEntityClass();
        if (mainClass.extendEntityClass() != null) {
            return mainClass.id() != entityClass.id() && mainClass.extendEntityClass().id() != entityClass.id();
        }
        return entityClass.id() != mainClass.id();
    }

    public static IEntity toEntity(IEntityClass entityClass, IEntityClassReader reader, EntityUp in) {
        return new Entity(in.getObjId(), entityClass, IEntityClassHelper.toEntityValue(reader, in));
    }

    public static IEntity toEntity(IEntityClass entityClass, IEntityClassReader reader, EntityUp in, int version) {
        return new Entity(in.getObjId(), entityClass, IEntityClassHelper.toEntityValue(reader, in), version);
    }

    public static EntityUp toEntityUp(IEntity entity) {
        EntityUp.Builder builder = EntityUp.newBuilder();
        if (entity.entityClass() != null) {
            builder.setId(entity.entityClass().id());
        }
        builder.setObjId(entity.id());
        builder.addAllValues((Iterable)entity.entityValue().values().stream().map(IEntityClassHelper::toValueUp).collect(Collectors.toList()));
        return builder.build();
    }

    private static ValueUp toValueUp(IValue value) {
        IEntityField field = value.getField();
        return ValueUp.newBuilder().setValue(IEntityClassHelper.toValueStr(value)).setName(field.name()).setFieldId(field.id()).setFieldType(field.type().name()).build();
    }

    private static String toValueStr(IValue value) {
        String retVal = (String)API.Match((Object)value).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(DateTimeValue.class)), x -> String.valueOf(x.valueToLong())), API.Case((API.Match.Pattern0)API.$(), IValue::valueToString)});
        return retVal;
    }

    public static EntityUp toEntityUp(IEntityClass entityClass, IEntityClass ... subEntityClass) {
        return IEntityClassHelper.toEntityUpBuilder(entityClass, null, subEntityClass).build();
    }

    public static EntityUp toEntityUp(IEntityClass entityClass) {
        return IEntityClassHelper.toEntityUpBuilder(entityClass, null).build();
    }

    public static EntityUp.Builder toEntityUpBuilder(IEntityClass entityClass, Long id) {
        return IEntityClassHelper.toEntityUpBuilder(entityClass, id, null);
    }

    public static EntityUp.Builder toEntityUpBuilder(IEntityClass entityClass, Long id, IEntityClass ... subEntityClass) {
        EntityUp.Builder builder = EntityUp.newBuilder();
        if (entityClass.extendEntityClass() != null) {
            IEntityClass parent = entityClass.extendEntityClass();
            EntityUp parentUp = IEntityClassHelper.toRawEntityUp(parent);
            builder.setExtendEntityClass(parentUp);
        }
        if (entityClass.ver() > 0) {
            builder.setVersion((long)entityClass.ver());
        }
        if (id != null) {
            builder.setObjId(id.longValue());
        }
        builder.addAllRelation((Iterable)entityClass.relations().stream().map(rel -> {
            RelationUp.Builder relation = RelationUp.newBuilder();
            if (rel.getEntityField() != null) {
                relation.setEntityField(IEntityClassHelper.toFieldUp(rel.getEntityField()));
            }
            relation.setName(Optional.ofNullable(rel.getName()).orElse(""));
            relation.setRelationType(rel.getRelationType());
            if (rel.isIdentity()) {
                relation.setIdentity(rel.isIdentity());
            }
            relation.setRelatedEntityClassId(rel.getEntityClassId());
            return relation.build();
        }).collect(Collectors.toList()));
        builder.setId(entityClass.id()).setCode(entityClass.code()).addAllFields((Iterable)entityClass.fields().stream().map(IEntityClassHelper::toFieldUp).collect(Collectors.toList()));
        if (entityClass.entityClasss() != null && !entityClass.entityClasss().isEmpty()) {
            builder.addAllEntityClasses((Iterable)entityClass.entityClasss().stream().map(IEntityClassHelper::toEntityUp).collect(Collectors.toList()));
        }
        if (subEntityClass == null) {
            if (entityClass.childEntityClasses() != null && !entityClass.childEntityClasses().isEmpty()) {
                builder.addAllNarrowEntityClasses((Iterable)entityClass.childEntityClasses().stream().map(IEntityClassHelper::toRawEntityUp).collect(Collectors.toList()));
            }
        } else {
            builder.addAllNarrowEntityClasses((Iterable)Stream.of(subEntityClass).map(IEntityClassHelper::toRawEntityUp).collect(Collectors.toList()));
        }
        return builder;
    }

    public static FieldUp toFieldUp(IEntityField field) {
        FieldUp.Builder builder = FieldUp.newBuilder().setCode(field.name()).setFieldType(field.type().name()).setId(field.id()).setName(Optional.ofNullable(field.cnName()).orElse("")).setDictId(Optional.ofNullable(field.dictId()).orElse(""));
        if (field.config() != null) {
            builder.setSearchable(String.valueOf(field.config().isSearchable()));
            builder.setMaxLength(String.valueOf(field.config().getMax()));
            builder.setMinLength(String.valueOf(field.config().getMin()));
            builder.setPrecision(field.config().getPrecision());
            builder.setIdentifier(field.config().isIdentifie());
            builder.setUniqueName(field.config().uniqueName());
            builder.setIsSystem(field.config().isSystem());
            builder.setRequired(Boolean.valueOf(field.config().isRequired()).toString());
        }
        if (field.defaultValue() != null) {
            builder.setDefaultValue(field.defaultValue());
        }
        return builder.build();
    }

    public static EntityUp toRawEntityUp(IEntityClass entity) {
        return EntityUp.newBuilder().setId(entity.id()).setVersion((long)entity.ver()).setCode(entity.code()).addAllFields((Iterable)entity.fields().stream().map(IEntityClassHelper::toFieldUp).collect(Collectors.toList())).build();
    }

    public static Optional<FieldConditionUp> toFieldCondition(Condition condition) {
        IEntityField field = condition.getField();
        IValue value = condition.getFirstValue();
        ConditionOperator operator = condition.getOperator();
        if (value == null || field == null || operator == null) {
            return Optional.empty();
        }
        FieldConditionUp fieldCondition = FieldConditionUp.newBuilder().setCode(field.name()).setOperation(IEntityClassHelper.toConditionOp(operator)).addValues(value.valueToString()).setField(IEntityClassHelper.toFieldUp(field)).build();
        return Optional.of(fieldCondition);
    }

    private static FieldConditionUp.Op toConditionOp(ConditionOperator conditionOperator) {
        FieldConditionUp.Op op;
        switch (conditionOperator) {
            case GREATER_THAN: {
                op = FieldConditionUp.Op.gt;
                break;
            }
            case GREATER_THAN_EQUALS: {
                op = FieldConditionUp.Op.ge;
                break;
            }
            case LIKE: {
                op = FieldConditionUp.Op.like;
                break;
            }
            case NOT_EQUALS: {
                op = FieldConditionUp.Op.ne;
                break;
            }
            case LESS_THAN_EQUALS: {
                op = FieldConditionUp.Op.le;
                break;
            }
            case LESS_THAN: {
                op = FieldConditionUp.Op.lt;
                break;
            }
            default: {
                op = FieldConditionUp.Op.eq;
            }
        }
        return op;
    }

    public static FieldSortUp toSortUp(IEntityField field, boolean isAsc) {
        return FieldSortUp.newBuilder().setCode(field.name()).setOrder(isAsc ? FieldSortUp.Order.asc : FieldSortUp.Order.desc).build();
    }

    public static EntityUp toEntityUp(IEntityClass entityClass, Long id, List<Tuple2<IEntityField, Object>> valueTuple) {
        EntityUp.Builder builder = IEntityClassHelper.toEntityUpBuilder(entityClass, id);
        List valueList = valueTuple.stream().filter(x -> x._2() != null).map(x -> ValueUp.newBuilder().setFieldId(((IEntityField)x._1).id()).setFieldType(((IEntityField)x._1).type().getType()).setValue(ConvertHelper.convert(x._2())).build()).collect(Collectors.toList());
        builder = builder.addAllValues(valueList);
        return builder.build();
    }

    public static EntityUp toEntityUp(IEntityClass entityClass, long id) {
        return IEntityClassHelper.toEntityUpBuilder(entityClass, id).build();
    }

    public static ConditionsUp toConditionsUp(Conditions conditions) {
        ConditionsUp.Builder conditionsUpBuilder = ConditionsUp.newBuilder();
        conditionsUpBuilder.addAllFields((Iterable)conditions.collect().stream().filter(Conditions::isValueNode).map(x -> ((ValueConditionNode)x).getCondition()).map(IEntityClassHelper::toFieldCondition).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        return conditionsUpBuilder.build();
    }

    public static Record toRecord(IEntityClassReader reader, EntityUp up, List<Long> ids) {
        Map<Tuple2<String, Long>, Object> retValue = up.getValuesList().stream().collect(Collectors.toMap(x -> Tuple.of((Object)x.getName(), (Object)x.getFieldId()), ValueUp::getValue));
        long id = up.getId();
        Record record = reader.toRecordNew(retValue, id);
        if (id > 0L) {
            record.setTypeId(id);
        }
        long objId = up.getObjId();
        record.setId(objId);
        if (ids.size() > 1) {
            record.setParentId(ids.get(1));
        }
        return record;
    }

    public static Collection<IEntityClass> flattenEntityClass(IEntityClass entityClass) {
        ArrayList<IEntityClass> flats = new ArrayList<IEntityClass>();
        if (null == entityClass) {
            return flats;
        }
        flats.add(entityClass);
        if (null != entityClass.childEntityClasses()) {
            flats.addAll(entityClass.childEntityClasses());
        }
        return flats;
    }

    public static Optional<IEntityClass> entityMember(Collection<IEntityClass> flatEntityClasses, long compareEntityClassId) {
        return flatEntityClasses.stream().filter(e -> e.id() == compareEntityClassId).findFirst();
    }

    public static boolean isEntityMember(IEntityClass entityClass, long compareEntityClassId) {
        List flattenEntityClasses = (List)IEntityClassHelper.flattenEntityClass(entityClass);
        return flattenEntityClasses.stream().anyMatch(e -> e.id() == compareEntityClassId);
    }
}

