/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.converter;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Condition;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.sdk.FilterNode;
import com.xforceplus.ultraman.oqsengine.sdk.Filters;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeExpHelper {
    private static Logger logger = LoggerFactory.getLogger(TreeExpHelper.class);

    public static Optional<Conditions> toConditions(IEntityClassReader reader, Filters filters) {
        if (!filters.isInitialized()) {
            return Optional.empty();
        }
        List filterList = filters.getNodesList();
        return filterList.stream().map(x -> TreeExpHelper.toConditions(x, reader)).filter(Objects::nonNull).reduce((a, b) -> a.addAnd((Conditions)b, true));
    }

    private static boolean isRelatedField(ColumnField columnField, IEntityClass mainClass) {
        IEntityClass entityClass = columnField.originEntityClass();
        if (mainClass.extendEntityClass() != null) {
            return mainClass.id() != entityClass.id() && mainClass.extendEntityClass().id() != entityClass.id();
        }
        return entityClass.id() != mainClass.id();
    }

    private static Conditions toConditions(FilterNode node, IEntityClassReader reader) {
        if (node.getNodeType() == 0) {
            List nodesList = node.getNodesList();
            if (FilterNode.Operator.or == node.getOperator()) {
                return nodesList.stream().filter(x -> x.getNodeType() == 0).map(x -> TreeExpHelper.toConditions(x, reader)).reduce((a, b) -> a.addOr((Conditions)b, true)).orElseThrow(() -> new RuntimeException("no conditions in OR"));
            }
            if (FilterNode.Operator.and == node.getOperator()) {
                return nodesList.stream().filter(x -> x.getNodeType() == 0).map(x -> TreeExpHelper.toConditions(x, reader)).reduce((a, b) -> a.addAnd((Conditions)b, true)).orElseThrow(() -> new RuntimeException("no conditions in AND"));
            }
            Optional<FilterNode> filterNode = TreeExpHelper.extractFieldNode(node);
            List<FilterNode> values = TreeExpHelper.extractValueNode(node);
            Conditions conditions = TreeExpHelper.toOneConditions(filterNode.flatMap(x -> reader.column(x.getPayload())), values.stream().map(FilterNode::getPayload).collect(Collectors.toList()), node.getOperator(), reader.getEntityClass());
            if (conditions == null) {
                throw new RuntimeException("Condition is invalid with field " + filterNode + " " + node.getOperator() + " values:" + values);
            }
            return conditions;
        }
        return null;
    }

    private static Optional<FilterNode> extractFieldNode(FilterNode node) {
        return node.getNodesList().stream().filter(x -> x.getNodeType() == 1).findFirst();
    }

    private static List<FilterNode> extractValueNode(FilterNode node) {
        return node.getNodesList().stream().filter(x -> x.getNodeType() == 2).collect(Collectors.toList());
    }

    private static Conditions toOneConditions(Optional<ColumnField> fieldOp, List<String> values, FilterNode.Operator op, IEntityClass mainClass) {
        Conditions conditions = null;
        if (fieldOp.isPresent()) {
            ColumnField columnField;
            ColumnField originField = columnField = fieldOp.get();
            List nonNullValueList = values.stream().filter(Objects::nonNull).collect(Collectors.toList());
            if (nonNullValueList.isEmpty()) {
                throw new RuntimeException("Field " + columnField + " Value is Missing");
            }
            switch (op) {
                case eq: {
                    conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case ne: {
                    conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.NOT_EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case ge: {
                    conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN_EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case gt: {
                    conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case ge_le: {
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN_EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0]));
                        Condition right = new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LESS_THAN_EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(1)).toArray(new IValue[0]));
                        conditions = new Conditions(left).addAnd(right);
                        break;
                    }
                    logger.warn("required value more then 2, fallback to ge");
                    conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN_EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case gt_le: {
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0]));
                        Condition right = new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LESS_THAN_EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(1)).toArray(new IValue[0]));
                        conditions = new Conditions(left).addAnd(right);
                        break;
                    }
                    logger.warn("required value more then 2, fallback to gt");
                    conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case ge_lt: {
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN_EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0]));
                        Condition right = new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LESS_THAN, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(1)).toArray(new IValue[0]));
                        conditions = new Conditions(left).addAnd(right);
                        break;
                    }
                    logger.warn("required value more then 2, fallback to ge");
                    conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN_EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case gt_lt: {
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0]));
                        Condition right = new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LESS_THAN, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(1)).toArray(new IValue[0]));
                        conditions = new Conditions(left).addAnd(right);
                        break;
                    }
                    logger.warn("required value more then 2, fallback to ge");
                    conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.GREATER_THAN_EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case le: {
                    conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LESS_THAN_EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case lt: {
                    conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LESS_THAN, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case in: {
                    conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.MULTIPLE_EQUALS, (IValue[])nonNullValueList.stream().flatMap(x -> TreeExpHelper.toTypedValue((IEntityField)fieldOp.get(), x).stream()).toArray(IValue[]::new)));
                    break;
                }
                case ni: {
                    if (nonNullValueList.size() == 1) {
                        conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.NOT_EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                        break;
                    }
                    Conditions finalConditions = conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.NOT_EQUALS, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    nonNullValueList.stream().skip(1L).forEach(x -> finalConditions.addAnd(new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.NOT_EQUALS, TreeExpHelper.toTypedValue((IEntityField)fieldOp.get(), x).toArray(new IValue[0]))), false));
                    conditions = finalConditions;
                    break;
                }
                case like: {
                    conditions = new Conditions(new Condition(TreeExpHelper.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.LIKE, TreeExpHelper.toTypedValue(fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
            }
        }
        return conditions;
    }

    private static List<IValue> toTypedValue(IEntityField entityField, String value) {
        return entityField.type().toTypedValue(entityField, value).map(Collections::singletonList).orElseGet(Collections::emptyList);
    }
}

