/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.conditions;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionLink;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionNode;
import java.util.Objects;

public class LinkConditionNode
extends ConditionNode {
    private ConditionLink link;

    public LinkConditionNode(ConditionNode l, ConditionNode r, ConditionLink link) {
        super(l, r);
        this.link = link;
    }

    public ConditionLink getLink() {
        return this.link;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.isClosed()) {
            buff.append("(");
        }
        buff.append(this.getLeft().toString()).append(" ").append(this.link.toString()).append(" ").append(this.getRight().toString());
        if (this.isClosed()) {
            buff.append(")");
        }
        return buff.toString();
    }

    @Override
    public String toPrefixExpression() {
        StringBuilder buff = new StringBuilder();
        if (this.isClosed()) {
            buff.append("(");
        }
        buff.append(this.link.toString()).append(this.isRed() ? "(r)" : "").append(" ").append(this.getLeft().toPrefixExpression()).append(" ").append(this.getRight().toPrefixExpression());
        if (this.isClosed()) {
            buff.append(")");
        }
        return buff.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinkConditionNode)) {
            return false;
        }
        LinkConditionNode other = (LinkConditionNode)o;
        if (this.link != other.link) {
            return false;
        }
        ConditionNode left = this.getLeft();
        ConditionNode otherLeft = other.getLeft();
        if (left == null && otherLeft != null || left != null && otherLeft == null) {
            return false;
        }
        if (!left.equals(otherLeft)) {
            return false;
        }
        ConditionNode right = this.getRight();
        ConditionNode othetRight = other.getRight();
        if (right == null && othetRight != null || right != null && othetRight == null) {
            return false;
        }
        return right.equals(othetRight);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getLink()});
    }
}

