/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.summary;

import com.xforceplus.ultraman.oqsengine.pojo.dto.summary.DataSourceSummary;
import com.xforceplus.ultraman.oqsengine.pojo.dto.summary.Offset;
import com.xforceplus.ultraman.oqsengine.pojo.dto.summary.OffsetSnapShot;
import com.xforceplus.ultraman.oqsengine.pojo.dto.summary.TableSummary;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;

public class BatchSummary {
    private List<DataSourceSummary> dataSourceSummaries;
    private CheckPointOffset checkPointOffset;

    public BatchSummary(List<DataSourceSummary> dataSourceSummaries) throws SQLException {
        this.dataSourceSummaries = dataSourceSummaries;
        this.checkPointOffset = new CheckPointOffset(this.dataSourceSummaries.iterator());
    }

    public boolean resetCheckPoint(OffsetSnapShot offsetSnapShot) {
        Iterator<DataSourceSummary> dataSourceSummaryIterator = this.dataSourceSummaries.iterator();
        DataSourceSummary dataSourceSummary = null;
        while (dataSourceSummaryIterator.hasNext() && !(dataSourceSummary = dataSourceSummaryIterator.next()).getPoolName().equalsIgnoreCase(offsetSnapShot.getDataSourceName())) {
        }
        if (null != dataSourceSummary) {
            Iterator<TableSummary> tableSummaryIterator = dataSourceSummary.getTableSummaries().iterator();
            while (tableSummaryIterator.hasNext() && !tableSummaryIterator.next().getTableName().equals(offsetSnapShot.getTableName())) {
            }
            this.checkPointOffset = new CheckPointOffset(dataSourceSummaryIterator, tableSummaryIterator, dataSourceSummary.getDataSource(), offsetSnapShot);
            return true;
        }
        return false;
    }

    public int count() {
        return this.dataSourceSummaries.stream().mapToInt(DataSourceSummary::getTotal).sum();
    }

    public boolean hasNext() {
        return this.checkPointOffset.hasNext();
    }

    public CheckPointOffset next() throws SQLException {
        if (this.checkPointOffset.hasNext()) {
            return this.checkPointOffset.next();
        }
        throw new SQLException("no more element");
    }

    public void offsetReset(long id) {
        if (0 < this.checkPointOffset.left()) {
            this.checkPointOffset.setOffset(id);
        }
        this.snapShot();
    }

    public OffsetSnapShot snapShot() {
        return this.checkPointOffset.offsetSnapShot();
    }

    public static class CheckPointOffset
    implements Offset {
        private CheckOffsetIterator checkOffsetIterator;
        private DataSource activeDataSource;
        private OffsetSnapShot offsetSnapShot;

        public CheckPointOffset(Iterator<DataSourceSummary> dataSourceSummaryIterator, Iterator<TableSummary> tableSummaryIterator, DataSource dataSource, OffsetSnapShot offsetSnapShot) {
            this.activeDataSource = dataSource;
            this.offsetSnapShot = offsetSnapShot;
            this.checkOffsetIterator = new CheckOffsetIterator(dataSourceSummaryIterator, tableSummaryIterator);
        }

        public CheckPointOffset(Iterator<DataSourceSummary> dataSourceSummaryIterator) throws SQLException {
            DataSourceSummary dataSourceSummary = dataSourceSummaryIterator.next();
            Iterator<TableSummary> tableSummaryIterator = dataSourceSummary.getTableSummaries().iterator();
            TableSummary tableSummary = tableSummaryIterator.next();
            this.checkOffsetIterator = new CheckOffsetIterator(dataSourceSummaryIterator, tableSummaryIterator);
            this.initOffsetSnapShot(dataSourceSummary, tableSummary);
        }

        private void initOffsetSnapShot(DataSourceSummary dataSourceSummary, TableSummary tableSummary) throws SQLException {
            if (null == this.offsetSnapShot && null == dataSourceSummary) {
                throw new SQLException("init offset error, must have dataSource");
            }
            String dataSourceName = null;
            if (null != dataSourceSummary) {
                this.activeDataSource = dataSourceSummary.getDataSource();
                dataSourceName = dataSourceSummary.getPoolName();
            } else {
                dataSourceName = this.offsetSnapShot.getDataSourceName();
            }
            this.offsetSnapShot = new OffsetSnapShot(dataSourceName, tableSummary.getTableName(), 0L, tableSummary.getCount());
        }

        public OffsetSnapShot offsetSnapShot() {
            return this.offsetSnapShot;
        }

        public DataSource getActiveDataSource() {
            return this.activeDataSource;
        }

        public boolean hasNext() {
            return this.checkOffsetIterator.hasNext() || this.offsetSnapShot.getLeft() > 0;
        }

        public CheckPointOffset next() throws SQLException {
            if (this.offsetSnapShot.getLeft() > 0) {
                return this;
            }
            if (this.checkOffsetIterator.hasNext()) {
                AbstractMap.SimpleEntry<DataSourceSummary, TableSummary> se = this.checkOffsetIterator.next();
                this.initOffsetSnapShot(se.getKey(), se.getValue());
                return this;
            }
            throw new SQLException("no more element");
        }

        @Override
        public long offset() {
            return this.offsetSnapShot.getStartId();
        }

        @Override
        public void setOffset(long id) {
            this.offsetSnapShot.setStartId(id);
        }

        @Override
        public void decrease(int v) {
            this.offsetSnapShot.setLeft(this.offsetSnapShot.getLeft() - v);
        }

        @Override
        public int left() {
            return this.offsetSnapShot.getLeft();
        }

        private static class CheckOffsetIterator {
            private Iterator<DataSourceSummary> dataSourceSummaryIterator;
            private Iterator<TableSummary> tableSummaryIterator;

            public CheckOffsetIterator(Iterator<DataSourceSummary> dataSourceSummaryIterator, Iterator<TableSummary> tableSummaryIterator) {
                this.dataSourceSummaryIterator = dataSourceSummaryIterator;
                this.tableSummaryIterator = tableSummaryIterator;
            }

            public boolean hasNext() {
                return this.dataSourceSummaryIterator.hasNext() || this.tableSummaryIterator.hasNext();
            }

            public AbstractMap.SimpleEntry<DataSourceSummary, TableSummary> next() {
                if (this.tableSummaryIterator.hasNext()) {
                    return new AbstractMap.SimpleEntry<Object, TableSummary>(null, this.tableSummaryIterator.next());
                }
                DataSourceSummary dataSourceSummary = this.dataSourceSummaryIterator.next();
                this.tableSummaryIterator = dataSourceSummary.getTableSummaries().iterator();
                return new AbstractMap.SimpleEntry<DataSourceSummary, TableSummary>(dataSourceSummary, this.tableSummaryIterator.next());
            }
        }
    }
}

