/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.page;

import com.xforceplus.ultraman.oqsengine.pojo.page.Page;
import com.xforceplus.ultraman.oqsengine.pojo.page.PageScope;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LimitedRangePage
extends Page
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 9022842831962237841L;
    private long _rangeL;
    private long _rangeR;

    public LimitedRangePage() {
        this._rangeL = 1L;
        this._rangeR = 10L;
    }

    public LimitedRangePage(long index, long pageSize, long rangeL, long rangeR) {
        super(index, pageSize);
        if (rangeL <= 0L || rangeR <= 0L) {
            throw new IllegalArgumentException("Range of data errors, line number limit is not less than about 1.");
        }
        if (rangeL > rangeR) {
            throw new IllegalArgumentException("Range of data errors, the left can not be equal to the right of the line number line number.");
        }
        this._rangeL = rangeL;
        this._rangeR = rangeR;
    }

    @Override
    public PageScope getNextPage() {
        PageScope scope = super.getNextPage();
        if (scope == null) {
            return null;
        }
        return this.limitRange(scope);
    }

    @Override
    public PageScope getAppointPage(long appointPageIndex) {
        PageScope scope = super.getAppointPage(appointPageIndex);
        if (scope == null) {
            return null;
        }
        return this.limitRange(scope);
    }

    private PageScope limitRange(PageScope scope) {
        long oldStart = scope.startLine;
        long oldEnd = scope.endLine;
        scope.startLine = oldStart + this._rangeL - 1L;
        scope.endLine = oldStart + this._rangeR - 1L;
        if (scope.startLine < oldStart) {
            scope.startLine = oldStart;
        }
        if (scope.endLine > oldEnd) {
            scope.endLine = oldEnd;
        }
        return scope;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._rangeL = in.readLong();
        this._rangeR = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this._rangeL);
        out.writeLong(this._rangeR);
    }

    @Override
    public boolean equals(Object obj) {
        boolean superEquals = super.equals(obj);
        if (superEquals) {
            LimitedRangePage other = (LimitedRangePage)obj;
            if (this._rangeL != other._rangeL) {
                return false;
            }
            if (this._rangeR != other._rangeR) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 89 * hash + (int)(this._rangeL ^ this._rangeL >>> 32);
        hash = 89 * hash + (int)(this._rangeR ^ this._rangeR >>> 32);
        return hash;
    }
}

