package com.xforceplus.ultraman.oqsengine.pojo.exmaple;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OqsengineExample {


    /**
     * id: 1
     * version: 1
     * code: "test-entity"
     * relations:
     * - id: null
     *   name: "rel1"
     *   entityClassId: 2
     *   entityClassName: null
     *   relOwnerClassId: 0
     *   relOwnerClassName: null
     *   relationType: "OneToOne"
     *   identity: false
     *   entityField:
     *     fId: 2001
     *     fName: "rel1.id"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "LONG"
     * - id: null
     *   name: "rel1Dup"
     *   entityClassId: 2
     *   entityClassName: null
     *   relOwnerClassId: 0
     *   relOwnerClassName: null
     *   relationType: "OneToOne"
     *   identity: false
     *   entityField:
     *     fId: 2004
     *     fName: "rel1Dup.id"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "LONG"
     * - id: null
     *   name: "rel2"
     *   entityClassId: 3
     *   entityClassName: null
     *   relOwnerClassId: 0
     *   relOwnerClassName: null
     *   relationType: "OneToMany"
     *   identity: false
     *   entityField:
     *     fId: 3001
     *     fName: "rel2.id"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "LONG"
     * - id: null
     *   name: "rel2Dup"
     *   entityClassId: 3
     *   entityClassName: null
     *   relOwnerClassId: 0
     *   relOwnerClassName: null
     *   relationType: "OneToMany"
     *   identity: false
     *   entityField:
     *     fId: 3004
     *     fName: "rel2Dup.id"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "LONG"
     * - id: null
     *   name: "rel3"
     *   entityClassId: 4
     *   entityClassName: null
     *   relOwnerClassId: 0
     *   relOwnerClassName: null
     *   relationType: "MultiValues"
     *   identity: false
     *   entityField:
     *     fId: 4001
     *     fName: "rel3.id"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "LONG"
     * relatedEntityClasses:
     * - id: 2
     *   code: "one2one-entity"
     *   relations: []
     *   fields:
     *   - fId: 2002
     *     fName: "fieldA2"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "STRING"
     *   - fId: 2003
     *     fName: "fieldA3"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "DECIMAL"
     * - id: 3
     *   code: "one2many-entity"
     *   relations: []
     *   fields:
     *   - fId: 3002
     *     fName: "fieldB2"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "STRING"
     *   - fId: 3003
     *     fName: "fieldB3"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "LONG"
     * - id: 4
     *   code: "multivalues-entity"
     *   relations: []
     *   fields:
     *   - fId: 4002
     *     fName: "fieldC2"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "STRING"
     *   - fId: 4003
     *     fName: "fieldC3"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "LONG"
     * fields:
     * - fId: 1001
     *   fName: "field1"
     *   fConfig:
     *     searchable: false
     *     max: 9223372036854775807
     *     min: -9223372036854775808
     *     precision: 0
     *     identifie: false
     *     validateRegexString: ""
     *     delimiter: ""
     *     displayType: ""
     *     uniqueName: ""
     *     system: false
     *     required: false
     *     splittable: false
     *   ftype: "LONG"
     * parentEntityClass:
     *   id: 11
     *   code: "parent-entity"
     *   relations: []
     *   fields:
     *   - fId: 11002
     *     fName: "fieldC2"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "STRING"
     *   - fId: 11003
     *     fName: "fieldC3"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "LONG"
     *   - fId: 11004
     *     fName: "fieldC3"
     *     fConfig:
     *       searchable: false
     *       max: 9223372036854775807
     *       min: -9223372036854775808
     *       precision: 0
     *       identifie: false
     *       validateRegexString: ""
     *       delimiter: ""
     *       displayType: ""
     *       uniqueName: ""
     *       system: false
     *       required: false
     *       splittable: false
     *     ftype: "LONG"
     * @return
     */
    public static IEntityClass complexEntityClassWithRelation(){
        EntityField rel1Field = new EntityField(2001L, "rel1.id", FieldType.LONG);
        EntityField relDupField = new EntityField(2004L, "rel1Dup.id", FieldType.LONG);
        EntityField rel2Field = new EntityField(3001L, "rel2.id", FieldType.LONG);
        EntityField rel2DupField = new EntityField(3004L, "rel2Dup.id", FieldType.LONG);
        EntityField rel3Field = new EntityField(4001L, "rel3.id", FieldType.LONG);

        Relation rel1 = new Relation("rel1", 2L
                , "OneToOne"
                , false, rel1Field);

        Relation rel1Dup = new Relation("rel1Dup", 2L
                , "OneToOne"
                , false, relDupField);

        Relation rel2 = new Relation("rel2", 3L
                , "OneToMany"
                , false, rel2Field);

        Relation rel2Dup = new Relation("rel2Dup", 3L
                , "OneToMany"
                , false, rel2DupField);

        Relation rel3 = new Relation("rel3", 4L
                , "MultiValues"
                , false, rel3Field);


        IEntityClass relatedEntityA = new EntityClass(2L,"one2one-entity"
                , Arrays.asList(new EntityField(2002L, "fieldA2", FieldType.STRING)
                , new EntityField(2003L, "fieldA3", FieldType.DECIMAL)));

        IEntityClass relatedEntityB = new EntityClass(3L,"one2many-entity"
                , Arrays.asList(new EntityField(3002L, "fieldB2", FieldType.STRING)
                , new EntityField(3003L, "fieldB3", FieldType.LONG)));

        IEntityClass relatedEntityC = new EntityClass(4L,"multivalues-entity"
                , Arrays.asList(new EntityField(4002L, "fieldC2", FieldType.STRING)
                , new EntityField(4003L, "fieldC3", FieldType.LONG)));


        IEntityClass parentEntity = new EntityClass(11L, "parent-entity"
                , Arrays.asList(new EntityField(11002L, "fieldC2", FieldType.STRING)
                , new EntityField(11003L, "fieldC3", FieldType.LONG)
                , new EntityField(11004L, "fieldC3", FieldType.LONG)));

        return new EntityClass(
                1L
                , 1
                , "test-entity"
                , Arrays.asList(rel1, rel1Dup, rel2, rel2Dup, rel3)
                , Arrays.asList(relatedEntityA, relatedEntityB, relatedEntityC)
                , parentEntity
                , Collections.emptyList()
                , Arrays.asList(new EntityField(1001L, "field1", FieldType.LONG)));
    }

    /**
     *
     * id: 100
     * version: 1
     * name: "a"
     * code: "a"
     * relations: []
     * relatedEntityClasses: []
     * fields:
     * - fId: 100
     *   fName: "field1"
     *   fDictId: "abc"
     *   fDefaultValue: "Happy"
     *   fConfig:
     *     searchable: false
     *     max: 9223372036854775807
     *     min: -9223372036854775808
     *     precision: 0
     *     identifie: false
     *     validateRegexString: ""
     *     delimiter: ""
     *     displayType: ""
     *     uniqueName: ""
     *     required: true
     *     splittable: false
     *     system: false
     *   ftype: "ENUM"
     * - fId: 101
     *   fName: "field2"
     *   fConfig:
     *     searchable: false
     *     max: 9223372036854775807
     *     min: -9223372036854775808
     *     precision: 0
     *     identifie: false
     *     validateRegexString: ""
     *     delimiter: ""
     *     displayType: ""
     *     uniqueName: ""
     *     required: true
     *     splittable: false
     *     system: false
     *   ftype: "STRING"
     * - fId: 102
     *   fName: "field3"
     *   fConfig:
     *     searchable: false
     *     max: 9223372036854775807
     *     min: -9223372036854775808
     *     precision: 0
     *     identifie: false
     *     validateRegexString: ""
     *     delimiter: ""
     *     displayType: ""
     *     uniqueName: ""
     *     required: true
     *     splittable: false
     *     system: false
     *   ftype: "DATETIME"
     * - fId: 103
     *   fName: "field4"
     *   fConfig:
     *     searchable: false
     *     max: 9223372036854775807
     *     min: -9223372036854775808
     *     precision: 0
     *     identifie: false
     *     validateRegexString: ""
     *     delimiter: ""
     *     displayType: ""
     *     uniqueName: ""
     *     required: true
     *     splittable: false
     *     system: false
     *   ftype: "DECIMAL"
     * - fId: 104
     *   fName: "field5"
     *   fConfig:
     *     searchable: false
     *     max: 9223372036854775807
     *     min: -9223372036854775808
     *     precision: 0
     *     identifie: false
     *     validateRegexString: ""
     *     delimiter: ""
     *     displayType: ""
     *     uniqueName: ""
     *     required: true
     *     splittable: false
     *     system: false
     *   ftype: "BOOLEAN"
     * - fId: 105
     *   fName: "field6"
     *   fConfig:
     *     searchable: false
     *     max: 9223372036854775807
     *     min: -9223372036854775808
     *     precision: 0
     *     identifie: false
     *     validateRegexString: ""
     *     delimiter: ""
     *     displayType: ""
     *     uniqueName: ""
     *     required: true
     *     splittable: false
     *     system: false
     *   ftype: "LONG"
     * - fId: 106
     *   fName: "field7"
     *   fConfig:
     *     searchable: false
     *     max: 9223372036854775807
     *     min: -9223372036854775808
     *     precision: 0
     *     identifie: false
     *     validateRegexString: ""
     *     delimiter: ""
     *     displayType: ""
     *     uniqueName: ""
     *     required: true
     *     splittable: false
     *     system: false
     *   ftype: "STRINGS"
     * any: false
     * dynamic: true
     *
     * entity class without relation
     * @param code
     * @return
     */
    public static IEntityClass simpleEntityClass(String code){

        FieldConfig fieldConfig1 = new FieldConfig().required(true);
        FieldConfig fieldConfig2 = new FieldConfig().required(true);
        FieldConfig fieldConfig3 = new FieldConfig().required(true);
        FieldConfig fieldConfig4 = new FieldConfig().required(true);
        FieldConfig fieldConfig5 = new FieldConfig().required(true);
        FieldConfig fieldConfig6 = new FieldConfig().required(true);

        /**
         * list with all kind
         */
        List<IEntityField> fields = Arrays.asList(
                new EntityField(100L, "field1", FieldType.ENUM, fieldConfig1, "abc", "Happy"),
                new EntityField(101L, "field2", FieldType.STRING, fieldConfig2, "", null),
                new EntityField(102L, "field3", FieldType.DATETIME, fieldConfig3, "", null),
                new EntityField(103L, "field4", FieldType.DECIMAL, fieldConfig4, "", null),
                new EntityField(104L, "field5", FieldType.BOOLEAN, fieldConfig5, "", null),
                new EntityField(105L, "field6", FieldType.LONG, fieldConfig6, "", null),
                new EntityField(106L, "field7", FieldType.STRINGS, fieldConfig6, "", null)
        );


        /**
         * (Long id,
         *                        int ver,
         *                        String code,
         *                        String name,
         *                        Collection<Relation> relations,
         *                        Collection<IEntityClass> entityClasss,
         *                        IEntityClass extendEntityClass,
         *                        Collection<IEntityField> fields) {
         */
        return new EntityClass(100L, 1, code, code, Collections.emptyList(), Collections.emptyList(), null, fields);
    }

    public static IEntityClass camelAndSnakePropertyEntityClass(String code){
        FieldConfig fieldConfig1 = new FieldConfig().required(false);
        FieldConfig fieldConfig2 = new FieldConfig().required(false);


        /**
         * list with all kind
         */
        List<IEntityField> fields = Arrays.asList(
                new EntityField(107L, "hello_world", FieldType.STRING, fieldConfig1, "", null),
                new EntityField(108L, "seeYou", FieldType.STRING, fieldConfig2, "", null)

        );


        /**
         * (Long id,
         *                        int ver,
         *                        String code,
         *                        String name,
         *                        Collection<Relation> relations,
         *                        Collection<IEntityClass> entityClasss,
         *                        IEntityClass extendEntityClass,
         *                        Collection<IEntityField> fields) {
         */
        return new EntityClass(101L, 1, code, code, Collections.emptyList(), Collections.emptyList(), null, fields);
    }
}
