/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.config;

import com.xforceplus.ultraman.config.ConfigConverter;
import com.xforceplus.ultraman.config.ConfigNode;
import com.xforceplus.ultraman.config.event.ChangeList;
import com.xforceplus.ultraman.config.storage.ConfigurationStorage;
import com.xforceplus.ultraman.config.strategy.ConfigInitStrategy;
import io.reactivex.Observable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationEngine<T, R extends ConfigNode> {
    private Logger logger = LoggerFactory.getLogger(ConfigurationEngine.class);
    private ConfigInitStrategy<T> configInitStrategy;
    private ConfigurationStorage<R> configurationStorage;
    private ConfigConverter<T, R> converter;
    private Observable<T> configSource;
    private Function<String, T> fetchOne;

    public void registerSource(Observable<T> source) {
        this.configSource = source;
    }

    public void registerFetchOne(Function<String, T> fetchOne) {
        this.fetchOne = fetchOne;
    }

    public void setConverter(ConfigConverter<T, R> converter) {
        this.converter = converter;
    }

    public void setConfigurationStorage(ConfigurationStorage configurationStorage) {
        this.configurationStorage = configurationStorage;
    }

    public ConfigNode read(String id) {
        return this.configurationStorage.getRawConfigNode(id);
    }

    public Observable<ChangeList<R>> getObservable() {
        if (this.configSource != null) {
            return this.configSource.concatMap(x -> {
                this.logger.debug("Consuming {}", x);
                return Observable.fromIterable(this.configurationStorage.feed(Optional.ofNullable(this.converter.convert(x)).map(Collections::singletonList).orElseGet(Collections::emptyList)));
            });
        }
        return null;
    }

    public List<ChangeList<R>> rebuild() {
        return this.configurationStorage.rebuild();
    }

    public void reSync(String id) {
        try {
            T t = this.fetchOne.apply(id);
            R r = this.converter.convert(t);
            this.configurationStorage.feed(Collections.singletonList(r));
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
        }
    }
}

