/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.config.buffer;

import com.xforceplus.ultraman.config.buffer.RingNode;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;

public class RingBuffer<T> {
    private List<RingNode<T>> ringNodeList = new LinkedList<RingNode<T>>();
    private RingNode<T> root;
    private RingNode<T> current;

    public RingBuffer(int size, Supplier<T> supplier) {
        if (size <= 0) {
            throw new RuntimeException("RingBuffer size should over 0");
        }
        this.root = new RingNode<T>(supplier.get());
        this.setRoot(this.root);
        for (int i = 1; i < size; ++i) {
            RingNode<T> ringNode = new RingNode<T>(supplier.get());
            this.addNode(ringNode);
        }
    }

    public RingBuffer(RingNode<T> root) {
        this.setRoot(root);
    }

    private void setRoot(RingNode<T> root) {
        this.root = root;
        this.current = this.root;
        this.current.setNext(root);
        this.ringNodeList.add(root);
    }

    public void addNode(RingNode<T> node) {
        this.current.setNext(node);
        node.setNext(this.root);
        this.current = node;
        this.ringNodeList.add(node);
    }

    public RingNode<T> getRoot() {
        return this.root;
    }

    public List<RingNode<T>> getRingNodeList() {
        return this.ringNodeList;
    }

    public RingNode<T> getCurrent() {
        return this.current;
    }

    public RingNode<T> getNext() {
        return this.current.next();
    }

    public void moveNext() {
        this.current = this.current.next();
    }
}

