/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.config.storage;

import com.xforceplus.ultraman.config.ConfigNode;
import com.xforceplus.ultraman.config.CurrentState;
import com.xforceplus.ultraman.config.EventStrategy;
import com.xforceplus.ultraman.config.event.ChangeList;
import com.xforceplus.ultraman.config.event.ConfigEvent;
import com.xforceplus.ultraman.config.strategy.impl.RecordItem;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ConfigurationStorage<C extends ConfigNode> {
    public boolean isDiscardConfigs(ConfigNode var1);

    public List<ChangeList<C>> rebuild();

    default public List<ChangeList<C>> feed(Collection<C> configNodes) {
        return ((Stream)configNodes.stream().parallel()).map(this::feedOne).filter(Objects::nonNull).collect(Collectors.toList());
    }

    default public ChangeList<C> feedOne(ConfigNode configNode) {
        if (this.isDiscardConfigs(configNode)) {
            return null;
        }
        Long currentTimestamp = LocalDateTime.now().atZone(ZoneId.of("Asia/Shanghai")).toEpochSecond();
        RecordItem record = new RecordItem(configNode, currentTimestamp);
        ConfigNode currentConfigNode = record.getConfigNode();
        String id = record.getConfigNode().id();
        String realId = configNode.type() + "-" + id;
        this.appendHistory(realId, record);
        ConfigNode originConfigNode = this.getCurrentConfigNode(realId);
        Set<ConfigEvent> events = this.getEventStrategy().emit(currentConfigNode.diff(Optional.ofNullable(originConfigNode).map(ConfigNode::getOrigin).orElse(null)));
        ChangeList<ConfigNode> changeList = new ChangeList<ConfigNode>(realId, configNode.type(), originConfigNode, currentConfigNode, events);
        this.appendChangeList(realId, changeList);
        this.updateCurrentConfigNode(realId, configNode);
        return changeList;
    }

    public EventStrategy<Object> getEventStrategy();

    public ConfigNode getCurrentConfigNode(String var1);

    public void appendChangeList(String var1, ChangeList<C> var2);

    public void appendHistory(String var1, RecordItem var2);

    public void updateCurrentConfigNode(String var1, C var2);

    public ConfigNode getRawConfigNode(String var1);

    public CurrentState getCurrentState();
}

