/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.config.storage.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.config.ConfigNode;
import com.xforceplus.ultraman.config.CurrentState;
import com.xforceplus.ultraman.config.EventStrategy;
import com.xforceplus.ultraman.config.event.ChangeList;
import com.xforceplus.ultraman.config.storage.ConfigurationStorage;
import com.xforceplus.ultraman.config.storage.impl.DefaultInMemoryConfigurationStorage;
import com.xforceplus.ultraman.config.strategy.DiscardStrategy;
import com.xforceplus.ultraman.config.strategy.impl.RecordItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileConfigurationStorage
implements ConfigurationStorage {
    private Logger logger = LoggerFactory.getLogger(DefaultFileConfigurationStorage.class);
    private String root;
    private Kryo kryo;
    private final Object writeHistoryFile = new Object();
    private final Object writeChangeList = new Object();
    private ObjectMapper mapper = new ObjectMapper();
    private DefaultInMemoryConfigurationStorage memoryConfigurationStorage;

    public DefaultFileConfigurationStorage(String root, Kryo kryo, EventStrategy eventStrategy, DiscardStrategy discardStrategy) {
        this.memoryConfigurationStorage = new DefaultInMemoryConfigurationStorage(eventStrategy, discardStrategy);
        this.root = root;
        this.kryo = kryo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendHistory(String id, RecordItem recordItem) {
        Object object = this.writeHistoryFile;
        synchronized (object) {
            this.memoryConfigurationStorage.appendHistory(id, recordItem);
            this.logger.debug("Appending history-{}", (Object)id);
            File file = Paths.get(this.root + "history-" + id, new String[0]).toFile();
            try {
                String s = this.mapper.writeValueAsString((Object)recordItem);
                FileUtils.write((File)file, (CharSequence)s, (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isDiscardConfigs(ConfigNode currentConfigNode) {
        return this.memoryConfigurationStorage.isDiscardConfigs(currentConfigNode);
    }

    public List<ChangeList> rebuild() {
        return this.rebuildChangeList("changelist");
    }

    private List<ChangeList> rebuildChangeList(String prefix) {
        List<ChangeList> list;
        block8: {
            Path dir = Paths.get(this.root, new String[0]);
            Stream<Path> paths = Files.find(dir, 1, (path, attrs) -> attrs.isRegularFile() && path.getFileName().toString().startsWith(prefix), new FileVisitOption[0]);
            try {
                List collect = paths.map(path -> {
                    String fileName = path.getFileName().toString();
                    String[] names = fileName.split("-");
                    LinkedList<ChangeList> changeListsFromFile = new LinkedList<ChangeList>();
                    if (names.length > 1) {
                        String id = names[names.length - 1];
                        this.logger.info("start to processing {}", (Object)fileName);
                        try (FileInputStream input = new FileInputStream(path.toFile());){
                            while (input.available() > 0) {
                                ChangeList obj = (ChangeList)this.kryo.readObject(new Input((InputStream)input), ChangeList.class);
                                if (obj != null) {
                                    changeListsFromFile.add(obj);
                                    continue;
                                }
                                this.logger.error("file is broken {}", (Object)path.getFileName().toString());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return changeListsFromFile;
                }).peek(changeList -> this.logger.debug("{}", changeList)).collect(Collectors.toList());
                list = collect.stream().map(this::rebuildFromChangeList).collect(Collectors.toList());
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
            paths.close();
        }
        return list;
    }

    private ChangeList rebuildFromChangeList(List<ChangeList> changeLists) {
        if (!changeLists.isEmpty()) {
            ChangeList lastChangeList = changeLists.get(changeLists.size() - 1);
            return this.memoryConfigurationStorage.feedOne((ConfigNode)lastChangeList.getCurrent());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendChangeList(String id, ChangeList changeList) {
        Object object = this.writeChangeList;
        synchronized (object) {
            this.memoryConfigurationStorage.appendChangeList(id, changeList);
            File file = Paths.get(this.root + "changelist-" + id, new String[0]).toFile();
            try (Output output = new Output((OutputStream)new FileOutputStream(file));){
                this.kryo.writeObject(output, (Object)changeList);
            }
            catch (IOException ex) {
                this.logger.error("{}", (Throwable)ex);
            }
        }
    }

    public EventStrategy getEventStrategy() {
        return this.memoryConfigurationStorage.getEventStrategy();
    }

    @Override
    public ConfigNode getCurrentConfigNode(String id) {
        return null;
    }

    @Override
    public ConfigNode getRawConfigNode(String id) {
        return this.memoryConfigurationStorage.getRawConfigNode(id);
    }

    @Override
    public CurrentState getCurrentState() {
        return this.memoryConfigurationStorage.getCurrentState();
    }

    public synchronized void updateCurrentConfigNode(String id, ConfigNode configNode) {
        this.memoryConfigurationStorage.updateCurrentConfigNode(id, configNode);
    }
}

