/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.config.storage.impl;

import com.xforceplus.ultraman.config.ConfigNode;
import com.xforceplus.ultraman.config.CurrentState;
import com.xforceplus.ultraman.config.EventStrategy;
import com.xforceplus.ultraman.config.buffer.RingBuffer;
import com.xforceplus.ultraman.config.event.ChangeList;
import com.xforceplus.ultraman.config.storage.ConfigurationStorage;
import com.xforceplus.ultraman.config.strategy.DiscardStrategy;
import com.xforceplus.ultraman.config.strategy.impl.RecordItem;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInMemoryConfigurationStorage<T, R, C extends ConfigNode<T, R>>
implements ConfigurationStorage<C> {
    Logger logger = LoggerFactory.getLogger(ConfigurationStorage.class);
    private Map<String, RingBuffer<ConfigNode<T, R>>> currentStateMap = new ConcurrentHashMap<String, RingBuffer<ConfigNode<T, R>>>();
    private Map<String, List<ChangeList<C>>> eventSourcing = new ConcurrentHashMap<String, List<ChangeList<C>>>();
    private Map<String, List<RecordItem>> historyRecords = new ConcurrentHashMap<String, List<RecordItem>>();
    private EventStrategy<R> eventStrategy;
    private DiscardStrategy discardStrategy;

    public DefaultInMemoryConfigurationStorage(EventStrategy<R> eventStrategy) {
        this.eventStrategy = eventStrategy;
    }

    public DefaultInMemoryConfigurationStorage(EventStrategy<R> eventStrategy, DiscardStrategy discardStrategy) {
        this.eventStrategy = eventStrategy;
        this.discardStrategy = discardStrategy;
    }

    @Override
    public ConfigNode<T, R> getCurrentConfigNode(String id) {
        RingBuffer<ConfigNode<T, R>> configNodeRingBuffer = this.currentStateMap.get(id);
        if (configNodeRingBuffer == null) {
            this.logger.info("Init slot for {}", (Object)id);
            configNodeRingBuffer = new RingBuffer<ConfigNode>(2, () -> null);
            RingBuffer<ConfigNode<T, R>> preview = this.currentStateMap.putIfAbsent(id, configNodeRingBuffer);
            this.logger.debug("preveiw:{}, {}", (Object)id, preview);
            configNodeRingBuffer = this.currentStateMap.get(id);
            this.logger.debug("current:{}, {}", (Object)id, configNodeRingBuffer);
        }
        return configNodeRingBuffer.getCurrent().getObject();
    }

    @Override
    public boolean isDiscardConfigs(ConfigNode configNode) {
        if (this.discardStrategy == null) {
            return false;
        }
        if (configNode == null) {
            return false;
        }
        String id = configNode.id();
        String realId = configNode.type() + "-" + id;
        boolean isDiscard = this.discardStrategy.test(this.getCurrentConfigNode(realId), configNode);
        if (isDiscard) {
            this.logger.debug("Discard configNode: " + configNode + " with Strategy: " + this.discardStrategy);
        }
        return isDiscard;
    }

    @Override
    public List<ChangeList<C>> rebuild() {
        this.logger.debug("Do Nothing when rebuild from Memory");
        return Collections.emptyList();
    }

    @Override
    public EventStrategy getEventStrategy() {
        return this.eventStrategy;
    }

    @Override
    public void appendHistory(String id, RecordItem recordItem) {
        String type = recordItem.getConfigNode().type();
        String realId = type + ":" + id;
        List<RecordItem> recordItems = this.historyRecords.get(realId);
        if (recordItems == null) {
            recordItems = new LinkedList<RecordItem>();
            this.historyRecords.putIfAbsent(realId, recordItems);
        }
        recordItems = this.historyRecords.get(realId);
        recordItems.add(recordItem);
    }

    @Override
    public void appendChangeList(String id, ChangeList<C> changeList) {
        String realId = changeList.getType() + ":" + id;
        List<ChangeList<C>> changeLists = this.eventSourcing.get(realId);
        if (changeLists == null) {
            changeLists = new LinkedList<ChangeList<C>>();
            this.eventSourcing.putIfAbsent(realId, changeLists);
        }
        changeLists = this.eventSourcing.get(realId);
        changeLists.add(changeList);
    }

    @Override
    public void updateCurrentConfigNode(String id, C configNode) {
        ConfigNode<T, R> currentConfigNode = this.getCurrentConfigNode(id);
        RingBuffer<ConfigNode<T, R>> configNodeRingBuffer = this.currentStateMap.get(id);
        configNodeRingBuffer.getCurrent().next().setObject((ConfigNode<C, R>)configNode);
        configNodeRingBuffer.moveNext();
    }

    @Override
    public ConfigNode getRawConfigNode(String id) {
        return this.getCurrentConfigNode(id);
    }

    @Override
    public CurrentState getCurrentState() {
        return new CurrentState(Collections.unmodifiableMap(this.eventSourcing), Collections.unmodifiableMap(this.historyRecords));
    }
}

