/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.config.strategy.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.xforceplus.ultraman.config.EventStrategy;
import com.xforceplus.ultraman.config.event.ConfigAddEvent;
import com.xforceplus.ultraman.config.event.ConfigDeleteEvent;
import com.xforceplus.ultraman.config.event.ConfigEvent;
import com.xforceplus.ultraman.config.event.ConfigUpdateEvent;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJsonEventStrategy
implements EventStrategy<JsonNode> {
    Logger logger = LoggerFactory.getLogger(EventStrategy.class);

    @Override
    public Set<ConfigEvent> emit(JsonNode diff) {
        HashSet<ConfigEvent> sets = new HashSet<ConfigEvent>();
        try {
            ArrayNode diffArray = (ArrayNode)diff;
            for (JsonNode node : diffArray) {
                String op = node.get("op").asText();
                String path = node.get("path").asText();
                if ("replace".equalsIgnoreCase(op) || "add".equalsIgnoreCase(op)) {
                    String value = node.get("value").asText();
                    if ("replace".equalsIgnoreCase(op)) {
                        sets.add(new ConfigUpdateEvent(path, value));
                        continue;
                    }
                    sets.add(new ConfigAddEvent(path, value));
                    continue;
                }
                sets.add(new ConfigDeleteEvent(path));
            }
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
        }
        return sets;
    }
}

