package com.xforceplus.ultraman.sdk.bulk.controller;

import com.xforceplus.ultraman.sdk.core.bulk.exporter.ExportSink;
import com.xforceplus.ultraman.sdk.core.bulk.importer.ImportService;
import com.xforceplus.ultraman.sdk.core.bulk.importer.ImportTemplateService;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * default download controller
 */
@RequestMapping("/download/")
public class DefaultDownloadController {

    private final ExportSink exportSink;

    private final ImportService importService;

    private final ImportTemplateService templateService;

    public DefaultDownloadController(ExportSink exportSink, ImportService importService, ImportTemplateService templateService) {
        this.exportSink = exportSink;
        this.importService = importService;
        this.templateService = templateService;
    }

    @GetMapping(value = "/file/template/{uuid}")
    public ResponseEntity<StreamingResponseBody> downloadTemplateFile(
              @PathVariable String uuid
            , @RequestParam(value = "filename", required = false) String filename
            , @RequestParam(required = false, value = "type", defaultValue = "xlsx") String fileType
    ) {
        InputStream templateStream = null;
        MediaType mediaType = null;
        String innerFileName = null;
        if (filename != null) {
            innerFileName = filename;
        } else {
            innerFileName = uuid;
        }

        try {
            templateStream = templateService.getCustomTemplateInputStream(uuid);
            mediaType = MediaType.APPLICATION_OCTET_STREAM;
        } catch (Exception e) {
            e.printStackTrace();
        }

        InputStream finalTemplateStream = templateStream;
        StreamingResponseBody responseBody = outputStream -> {
            StreamUtils.copy(finalTemplateStream, outputStream);
            outputStream.close();
        };

        String encodedName = innerFileName;
        try {
            encodedName = URLEncoder.encode(innerFileName, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        return ResponseEntity.ok()
                .header(HttpHeaders.CONTENT_DISPOSITION,
                        "attachment; filename=" + encodedName + "." + fileType)
                .contentType(mediaType)
                .body(responseBody);
    }


    //TODO default is csv
    @GetMapping(value = "/file/{token}")
    public ResponseEntity<StreamingResponseBody> uploadFile(@PathVariable String token
            , @RequestParam(value = "filename", required = false) String filename
            , @RequestParam(required = false, value = "type", defaultValue = "xls") String fileType
    ) {

        InputStream input = null;
        MediaType mediaType = null;
        String innerFileName = null;
        if (filename != null) {
            innerFileName = filename;
        } else {
            innerFileName = token;
        }

        try {
            input = exportSink.getInputStream(token, fileType);
            mediaType = MediaType.APPLICATION_OCTET_STREAM;
        } catch (Exception e) {
            e.printStackTrace();
        }

        InputStream finalInput = input;
        StreamingResponseBody responseBody = outputStream -> {
            StreamUtils.copy(finalInput, outputStream);
            outputStream.close();
        };

        String encodedName = innerFileName;
        try {
            encodedName = URLEncoder.encode(innerFileName, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        return ResponseEntity.ok()
                .header(HttpHeaders.CONTENT_DISPOSITION,
                        "attachment; filename=" + encodedName + "." + fileType)
                .contentType(mediaType)
                .body(responseBody);
    }
}
