package com.xforceplus.ultraman.sdk.bulk.controller.dto;

import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.web.multipart.MultipartFile;

import java.util.Map;

/**
 * https://xforceplus.yuque.com/dew9bm/ohibpf/mu39tnlhcwme1m7h
 */
@Data
public class ImportRequest {
    private String v;
    private String appId; // 对应用户中心的应用id
    private String pageCode;
    private String importMode;// base wizard
    private String sheets;
    private String toManyRelations;
    private int step = 1000;
    private int timeout = 300000;
    private Boolean async = false;
    private Boolean useBatch = true;
    private Boolean onlyCheck = false; // 仅校验模式，数据不入库，抛事件业务方自己解析
    private String extra; // 额外参数，json格式，map结构
    private MultipartFile file;
}

