/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.graphql.builder;

import com.xforceplus.ultraman.bocp.gen.typed.TypedField;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.sdk.graphql.builder.ConditionBuilder;
import java.util.Arrays;
import java.util.List;

public interface ConditionNode {

    public static class OrderStep {
        private String fieldName;
        private int order;

        public OrderStep(String fieldName, int order) {
            this.fieldName = fieldName;
            this.order = order;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int getOrder() {
            return this.order;
        }
    }

    public static class OperateStep<T> {
        private String fieldName;

        public OperateStep(TypedField<T> typedField) {
            this.fieldName = typedField.code();
        }

        public OperateStep(String fieldName) {
            this.fieldName = fieldName;
        }

        public ConditionBuilder eq(T value) {
            return new ConditionBuilder(this.fieldName, ConditionOp.eq, value);
        }

        public ConditionBuilder notEq(T value) {
            return new ConditionBuilder(this.fieldName, ConditionOp.ne, value);
        }

        public ConditionBuilder in(List<T> values) {
            return new ConditionBuilder(this.fieldName, ConditionOp.in, values);
        }

        public ConditionBuilder in(T ... value) {
            return new ConditionBuilder(this.fieldName, ConditionOp.in, Arrays.asList(value));
        }

        public ConditionBuilder ni(T ... value) {
            return new ConditionBuilder(this.fieldName, ConditionOp.ni, Arrays.asList(value));
        }

        public ConditionBuilder ni(List<T> values) {
            return new ConditionBuilder(this.fieldName, ConditionOp.like, values);
        }

        public ConditionBuilder gt(T value) {
            return new ConditionBuilder(this.fieldName, ConditionOp.gt, value);
        }

        public ConditionBuilder ge(T value) {
            return new ConditionBuilder(this.fieldName, ConditionOp.ge, value);
        }

        public ConditionBuilder lt(T value) {
            return new ConditionBuilder(this.fieldName, ConditionOp.lt, value);
        }

        public ConditionBuilder le(T value) {
            return new ConditionBuilder(this.fieldName, ConditionOp.le, value);
        }

        public ConditionBuilder gt_le(T left, T right) {
            return new ConditionBuilder(this.fieldName, ConditionOp.gt_le, Arrays.asList(left, right));
        }

        public ConditionBuilder gt_lt(T left, T right) {
            return new ConditionBuilder(this.fieldName, ConditionOp.gt_lt, Arrays.asList(left, right));
        }

        public ConditionBuilder ge_lt(T left, T right) {
            return new ConditionBuilder(this.fieldName, ConditionOp.ge_lt, Arrays.asList(left, right));
        }

        public ConditionBuilder ge_le(T left, T right) {
            return new ConditionBuilder(this.fieldName, ConditionOp.ge_le, Arrays.asList(left, right));
        }

        public ConditionBuilder exists() {
            return new ConditionBuilder(this.fieldName, ConditionOp.exists, null);
        }

        public ConditionBuilder isNull() {
            return new ConditionBuilder(this.fieldName, ConditionOp.nil, null);
        }

        public ConditionBuilder like(String like) {
            return new ConditionBuilder(this.fieldName, ConditionOp.like, like);
        }

        public OrderStep asc() {
            return new OrderStep(this.fieldName, 0);
        }

        public OrderStep desc() {
            return new OrderStep(this.fieldName, 1);
        }
    }
}

