/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.graphql.builder;

import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpField;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRange;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpSort;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpValue;
import com.xforceplus.ultraman.sdk.graphql.builder.AndConditionBuilder;
import com.xforceplus.ultraman.sdk.graphql.builder.ConditionBuilder;
import com.xforceplus.ultraman.sdk.graphql.builder.ConditionNode;
import com.xforceplus.ultraman.sdk.graphql.builder.OrConditionBuilder;
import com.xforceplus.ultraman.sdk.graphql.builder.PageBuilder;
import com.xforceplus.ultraman.sdk.graphql.builder.SelectBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class QueryBuildFactory {
    private List<ConditionNode> conditionNodes;
    private SelectBuilder selectBuilder;
    private PageBuilder pageBuilder;
    private List<ConditionNode.OrderStep> orderSteps;

    public void setConditionNodes(List<ConditionNode> conditionNodes) {
        this.conditionNodes = conditionNodes;
    }

    public SelectBuilder getSelectBuilder() {
        return this.selectBuilder;
    }

    public void setSelectBuilder(SelectBuilder selectBuilder) {
        this.selectBuilder = selectBuilder;
    }

    public PageBuilder getPageBuilder() {
        return this.pageBuilder;
    }

    public void setPageBuilder(PageBuilder pageBuilder) {
        this.pageBuilder = pageBuilder;
    }

    public List<ConditionNode.OrderStep> getOrderSteps() {
        return this.orderSteps;
    }

    public void setOrderSteps(List<ConditionNode.OrderStep> orderSteps) {
        this.orderSteps = orderSteps;
    }

    private ExpNode traversal(ConditionNode conditionNode) {
        if (conditionNode instanceof ConditionBuilder) {
            ConditionBuilder conditionBuilder = (ConditionBuilder)conditionNode;
            String fieldName = conditionBuilder.getFieldName();
            ConditionOp op = conditionBuilder.getOp();
            List<?> values = conditionBuilder.getValues();
            ExpCondition currentNode = values != null ? ExpCondition.call((ExpOperator)ExpOperator.from((ConditionOp)op), (ExpNode)ExpField.field((String)fieldName), (List)ExpValue.from(conditionBuilder.getValues())) : ExpCondition.call((ExpOperator)ExpOperator.from((ConditionOp)op), (ExpNode[])new ExpNode[]{ExpField.field((String)fieldName)});
            return currentNode;
        }
        if (conditionNode instanceof OrConditionBuilder) {
            OrConditionBuilder orConditionBuilder = (OrConditionBuilder)conditionNode;
            List<ConditionNode> orList = orConditionBuilder.getOrList();
            List orConditions = orList.stream().map(x -> this.traversal((ConditionNode)x)).collect(Collectors.toList());
            return ExpCondition.call((ExpOperator)ExpOperator.OR, orConditions);
        }
        if (conditionNode instanceof AndConditionBuilder) {
            AndConditionBuilder andConditionBuilder = (AndConditionBuilder)conditionNode;
            List<ConditionNode> andList = andConditionBuilder.getAndList();
            List andConditions = andList.stream().map(x -> this.traversal((ConditionNode)x)).collect(Collectors.toList());
            return ExpCondition.call((ExpOperator)ExpOperator.AND, andConditions);
        }
        return ExpCondition.alwaysTrue();
    }

    public ExpRel build() {
        ExpQuery expQuery = new ExpQuery();
        ArrayList<ExpCondition> nodes = new ArrayList<ExpCondition>();
        if (this.conditionNodes != null && !this.conditionNodes.isEmpty()) {
            for (ConditionNode conditionNode : this.conditionNodes) {
                ExpCondition node = (ExpCondition)this.traversal(conditionNode);
                if (node.isAlwaysTrue()) continue;
                nodes.add(node);
            }
            if (!nodes.isEmpty()) {
                expQuery.filters(nodes);
            }
        }
        if (this.selectBuilder != null) {
            List<String> items = this.selectBuilder.getItems();
            expQuery.project(items.stream().map(ExpField::field).collect(Collectors.toList()));
        }
        if (this.orderSteps != null && !this.orderSteps.isEmpty()) {
            List sorts = this.orderSteps.stream().map(x -> new ExpSort.FieldSort(x.getFieldName(), x.getOrder() == 0 ? ExpSort.Sort.ASCEND : ExpSort.Sort.DESCEND)).collect(Collectors.toList());
            expQuery.sort(ExpSort.init().setSorts(sorts));
        }
        if (this.pageBuilder != null) {
            ExpRange range = new ExpRange(Integer.valueOf(this.pageBuilder.getPageNo()), Integer.valueOf(this.pageBuilder.getPageSize()));
            expQuery.range(range);
        }
        return expQuery;
    }
}

