/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.graphql.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.ultraman.sdk.graphql.gen.OqsTypesFactory;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationOptions;
import graphql.schema.GraphQLSchema;
import org.springframework.beans.factory.annotation.Autowired;

public class GraphQLSchemaHolder
implements Refreshable {
    @Autowired
    private OqsTypesFactory typesFactory;
    @Autowired
    private AsyncExecutionStrategy asyncExecutionStrategy;
    private LoadingCache<String, GraphQL> l2Cache = Caffeine.newBuilder().maximumSize(1000L).build(key -> {
        GraphQLSchema schema = this.typesFactory.genSchema((String)key);
        DataLoaderDispatcherInstrumentationOptions options = DataLoaderDispatcherInstrumentationOptions.newOptions().includeStatistics(true);
        return GraphQL.newGraphQL((GraphQLSchema)schema).queryExecutionStrategy((ExecutionStrategy)this.asyncExecutionStrategy).instrumentation((Instrumentation)new DataLoaderDispatcherInstrumentation(options)).build();
    });

    public OqsTypesFactory getTypesFactory() {
        return this.typesFactory;
    }

    public void setTypesFactory(OqsTypesFactory typesFactory) {
        this.typesFactory = typesFactory;
    }

    public GraphQL getGraphQL(String profile) {
        return (GraphQL)this.l2Cache.get((Object)profile);
    }

    public void clearAll() {
        this.l2Cache.invalidateAll();
    }

    public void onRefresh(Object payload) {
        this.clearAll();
    }
}

