/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.graphql.gen;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.facade.QueryProvider;
import io.vavr.Tuple2;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.BatchLoaderWithContext;

public class BatchDataLoader
implements BatchLoaderWithContext<Tuple2<IEntityClass, String>, Object> {
    final List<QueryProvider> queryProviders;

    public BatchDataLoader(List<QueryProvider> queryProviders) {
        this.queryProviders = queryProviders;
    }

    public CompletionStage<List<Object>> load(List<Tuple2<IEntityClass, String>> keys, BatchLoaderEnvironment environment) {
        Map<IEntityClass, List<Tuple2>> grouping = keys.stream().collect(Collectors.groupingBy(x -> (IEntityClass)x._1));
        HashMap merged = new HashMap();
        grouping.forEach((k, v) -> {
            List ids = v.stream().map(x -> (String)x._2()).collect(Collectors.toList());
            merged.put(k, ids);
        });
        Optional first = merged.entrySet().stream().findFirst();
        if (first.isPresent()) {
            Map.Entry entry = (Map.Entry)first.get();
            List value = (List)entry.getValue();
            IEntityClass key = (IEntityClass)entry.getKey();
            Optional<QueryProvider> provider = this.queryProviders.stream().filter(x -> x.accept(key)).findFirst();
            if (provider.isPresent()) {
                return provider.get().batchQuery(key, value);
            }
            throw new RuntimeException("No suitable Batch Query for entity " + key.code());
        }
        throw new RuntimeException("Size not ok");
    }
}

