/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.graphql.gen;

import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.facade.MutationProvider;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.QueryProvider;
import com.xforceplus.ultraman.sdk.core.facade.option.QueryOption;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpCondition;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFactory;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpField;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpNode;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpSort;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpValue;
import com.xforceplus.ultraman.sdk.graphql.gen.OqsTypesFactory;
import graphql.GraphQLContext;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import io.vavr.Tuple;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dataloader.DataLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OqsDataFetcher
implements DataFetcher {
    private static final Logger log = LoggerFactory.getLogger(OqsDataFetcher.class);
    @Autowired
    private List<MutationProvider> mutationProviders;
    @Autowired
    private List<QueryProvider> queryProviders;
    @Autowired
    private ProfileFetcher fetcher;
    @Autowired
    private EntityClassEngine engine;
    @Autowired
    private ContextService contextService;

    public List<MutationProvider> getMutationProviders() {
        return this.mutationProviders;
    }

    public void setMutationProviders(List<MutationProvider> mutationProviders) {
        this.mutationProviders = mutationProviders;
    }

    public List<QueryProvider> getQueryProviders() {
        return this.queryProviders;
    }

    public void setQueryProviders(List<QueryProvider> queryProviders) {
        this.queryProviders = queryProviders;
    }

    public ProfileFetcher getFetcher() {
        return this.fetcher;
    }

    public void setFetcher(ProfileFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public EntityClassEngine getEngine() {
        return this.engine;
    }

    public void setEngine(EntityClassEngine engine) {
        this.engine = engine;
    }

    public ContextService getContextService() {
        return this.contextService;
    }

    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(DataFetchingEnvironment environment) throws Exception {
        block10: {
            Object remoteQuery;
            block11: {
                block13: {
                    block12: {
                        OperationDefinition operationDefinition;
                        Optional entityClassOp;
                        block9: {
                            String profile = this.fetcher.getProfile(this.contextService.getAll());
                            List directives = environment.getFieldDefinition().getAppliedDirectives();
                            if (directives.isEmpty()) return null;
                            Optional<GraphQLAppliedDirective> coded = directives.stream().filter(x -> x.getName().equals(OqsTypesFactory.CODED_APPLIED.getName())).findAny();
                            String entityCode = null;
                            if (!coded.isPresent()) return null;
                            GraphQLAppliedDirectiveArgument argument = coded.get().getArgument("code");
                            if (argument == null) return null;
                            entityCode = argument.getValue().toString();
                            entityClassOp = this.engine.loadByCode(entityCode, profile);
                            if (!entityClassOp.isPresent()) throw new RuntimeException("Related entityClass not found");
                            operationDefinition = environment.getOperationDefinition();
                            if (operationDefinition.getOperation() != OperationDefinition.Operation.MUTATION) break block9;
                            return this.mutation(environment, (IEntityClass)entityClassOp.get());
                        }
                        if (operationDefinition.getOperation() != OperationDefinition.Operation.QUERY) break block10;
                        remoteQuery = this.query(environment, (IEntityClass)entityClassOp.get());
                        GraphQLAppliedDirective one2one = environment.getFieldDefinition().getAppliedDirective("one2one");
                        if (one2one == null) break block11;
                        if (!(remoteQuery instanceof CompletableFuture)) break block12;
                        return ((CompletableFuture)remoteQuery).thenApply(x -> {
                            if (x instanceof List && !((List)x).isEmpty()) {
                                return ((List)x).get(0);
                            }
                            return x;
                        });
                    }
                    if (!(remoteQuery instanceof List) || ((List)remoteQuery).isEmpty()) break block13;
                    return ((List)remoteQuery).get(0);
                }
                return null;
            }
            return remoteQuery;
        }
        try {
            throw new RuntimeException("Operation is not supported");
        }
        catch (Exception ex) {
            log.error("inner ex {}", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object query(DataFetchingEnvironment environment, IEntityClass entityClass) {
        Map condition = (Map)environment.getArgument("_filter");
        List sort = (List)environment.getArgument("_order");
        Integer pageSize = (Integer)environment.getArgumentOrDefault("pageSize", (Object)20);
        Integer pageNo = (Integer)environment.getArgumentOrDefault("pageNo", (Object)1);
        ExpCondition fromGraphQLMap = ExpCondition.alwaysTrue();
        if (condition != null) {
            fromGraphQLMap = ExpFactory.createFromGraphQLMap((Map)condition);
        }
        ExpSort expSort = new ExpSort();
        if (sort != null && !sort.isEmpty()) {
            sort.forEach(entry -> {
                Object code = entry.get("code");
                Object order = entry.get("_order");
                if (code != null && order != null) {
                    expSort.withSort(code.toString(), order.toString());
                }
            });
        }
        ExpCondition finalCondition = fromGraphQLMap;
        Map source = (Map)environment.getSource();
        if (source != null) {
            boolean one2one = environment.getFieldDefinition().getAppliedDirectives().stream().anyMatch(x -> x.getName().equals("one2one"));
            boolean one2Many = environment.getFieldDefinition().getAppliedDirectives().stream().anyMatch(x -> x.getName().equals("one2many"));
            String relatedCode = environment.getFieldDefinition().getName();
            if (one2one) {
                Object id = source.get("_".concat(relatedCode.concat("_id")));
                if (id == null) return null;
                DataLoader dataLoader = environment.getDataLoader(entityClass.code());
                if (dataLoader != null) {
                    return dataLoader.load((Object)Tuple.of((Object)entityClass, (Object)id.toString()), (Object)environment);
                }
            } else if (one2Many) {
                Object id = source.get("id");
                Optional<GraphQLAppliedDirective> one2many = environment.getFieldDefinition().getAppliedDirectives().stream().filter(x -> x.getName().equals("one2many")).findAny();
                GraphQLAppliedDirective one2may = one2many.get();
                Object value = one2may.getArgument("code").getValue();
                if (value != null) {
                    relatedCode = value.toString();
                }
                if (id == null) return null;
                ExpCondition relatedId = ExpCondition.call((ExpOperator)ExpOperator.EQUALS, (ExpNode)ExpField.field((String)relatedCode.concat(".id")), (List)ExpValue.from(id));
                finalCondition = ExpCondition.call((ExpOperator)ExpOperator.AND, (ExpNode[])new ExpNode[]{fromGraphQLMap, relatedId});
            }
        }
        ExpQuery query = new ExpQuery().filters((ExpNode)finalCondition).sort(expSort).range(pageNo, pageSize);
        return this.doQuery(entityClass, (ExpRel)query, environment);
    }

    private Object doQuery(IEntityClass entityClass, ExpRel expRel, DataFetchingEnvironment environment) {
        Optional<QueryProvider> queryProvider = this.queryProviders.stream().filter(x -> x.accept(entityClass)).findFirst();
        if (queryProvider.isPresent()) {
            boolean unbox = environment.getFieldDefinition().getAppliedDirectives().stream().anyMatch(x -> OqsTypesFactory.UNBOX_APPLIED.getName().equals(x.getName()));
            Object queryResult = queryProvider.get().query(entityClass, expRel, new QueryOption[]{unbox ? QueryOption.UNBOX : QueryOption.NONE});
            return queryResult;
        }
        throw new RuntimeException();
    }

    private String mutation(DataFetchingEnvironment environment, IEntityClass entityClass) {
        List directives = environment.getFieldDefinition().getAppliedDirectives();
        if (!directives.isEmpty()) {
            if (directives.stream().anyMatch(x -> x.getName().equals(OqsTypesFactory.ADD.getName()))) {
                return this.doCreate(environment, entityClass);
            }
            if (directives.stream().anyMatch(x -> x.getName().equals(OqsTypesFactory.UPDATE.getName()))) {
                return this.doUpdate(environment, entityClass);
            }
            if (directives.stream().anyMatch(x -> x.getName().equals(OqsTypesFactory.DELETE.getName()))) {
                return this.doDelete(environment, entityClass);
            }
            if (directives.stream().anyMatch(x -> x.getName().equals(OqsTypesFactory.BATCH_ADD.getName()))) {
                return this.doBatchCreate(environment, entityClass);
            }
            if (directives.stream().anyMatch(x -> x.getName().equals(OqsTypesFactory.BATCH_UPDATE.getName()))) {
                return this.doBatchUpdate(environment, entityClass);
            }
            if (directives.stream().anyMatch(x -> x.getName().equals(OqsTypesFactory.BATCH_DELETE.getName()))) {
                return this.doBatchDelete(environment, entityClass);
            }
            if (directives.stream().anyMatch(x -> x.getName().equals(OqsTypesFactory.CUSTOM_APPLIED.getName()))) {
                return this.doCustom(environment, entityClass);
            }
            throw new RuntimeException("Not supported operation");
        }
        return "\u64cd\u4f5c\u5931\u8d25";
    }

    private Map<String, Object> recreate(Map<String, Object> argument) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        argument.forEach((k, v) -> {
            String key = k;
            if (k.startsWith("_")) {
                key = k.substring(1).replace('_', '.');
            }
            if (v == null) {
                v = EmptyValue.emptyValue;
            }
            map.put(key, v);
        });
        return map;
    }

    public String getTransactionId(DataFetchingEnvironment environment) {
        Object o;
        GraphQLContext context;
        String transactionId = null;
        List mutationDirectives = environment.getOperationDefinition().getDirectives();
        if (!mutationDirectives.isEmpty() && mutationDirectives.stream().anyMatch(x -> x.getName().equalsIgnoreCase(OqsTypesFactory.TRANSACTIONAL_D_APPLIED.getName())) && (context = environment.getGraphQlContext()) != null && (o = context.get((Object)"transactional")) != null) {
            transactionId = o.toString();
        }
        return transactionId;
    }

    private String doCreate(DataFetchingEnvironment env, IEntityClass entityClass) {
        Map argument = (Map)env.getArgument("_input");
        Optional<MutationProvider> mutationProvider = this.mutationProviders.stream().filter(x -> x.accept(entityClass)).findFirst();
        if (mutationProvider.isPresent()) {
            Map<String, Object> context = this.getContext(env);
            String transactionId = this.getTransactionId(env);
            if (!StringUtils.isEmpty((CharSequence)transactionId)) {
                context.put(ContextKeys.StringKeys.TRANSACTION_KEY.name(), transactionId);
            }
            return mutationProvider.get().create(entityClass, this.recreate(Optional.ofNullable(argument).orElseGet(Collections::emptyMap)), context);
        }
        throw new RuntimeException("Create Mutation is not Support");
    }

    private String doBatchCreate(DataFetchingEnvironment env, IEntityClass entityClass) {
        List argument = (List)env.getArgument("_input");
        Optional<MutationProvider> mutationProvider = this.mutationProviders.stream().filter(x -> x.accept(entityClass)).findFirst();
        if (mutationProvider.isPresent()) {
            Map<String, Object> context = this.getContext(env);
            String transactionId = this.getTransactionId(env);
            if (!StringUtils.isEmpty((CharSequence)transactionId)) {
                context.put(ContextKeys.StringKeys.TRANSACTION_KEY.name(), transactionId);
            }
            List inputBodies = Optional.ofNullable(argument).orElseGet(Collections::emptyList).stream().map(x -> this.recreate((Map<String, Object>)x)).collect(Collectors.toList());
            return mutationProvider.get().batchCreate(entityClass, inputBodies, context);
        }
        throw new RuntimeException("Batch Create Mutation is not Support");
    }

    private String doBatchUpdate(DataFetchingEnvironment env, IEntityClass entityClass) {
        List argument = (List)env.getArgument("_input");
        Optional<MutationProvider> mutationProvider = this.mutationProviders.stream().filter(x -> x.accept(entityClass)).findFirst();
        if (mutationProvider.isPresent()) {
            Map<String, Object> context = this.getContext(env);
            String transactionId = this.getTransactionId(env);
            if (!StringUtils.isEmpty((CharSequence)transactionId)) {
                context.put(ContextKeys.StringKeys.TRANSACTION_KEY.name(), transactionId);
            }
            List inputBodies = Optional.ofNullable(argument).orElseGet(Collections::emptyList).stream().map(x -> this.recreate((Map<String, Object>)x)).collect(Collectors.toList());
            return mutationProvider.get().batchUpdate(entityClass, inputBodies, context);
        }
        throw new RuntimeException("Batch Update Mutation is not Support");
    }

    private String doUpdate(DataFetchingEnvironment env, IEntityClass entityClass) {
        String id = (String)env.getArgument("id");
        Map argument = (Map)env.getArgument("_input");
        Optional<MutationProvider> mutationProvider = this.mutationProviders.stream().filter(x -> x.accept(entityClass)).findFirst();
        if (mutationProvider.isPresent()) {
            Map<String, Object> context = this.getContext(env);
            String transactionId = this.getTransactionId(env);
            if (!StringUtils.isEmpty((CharSequence)transactionId)) {
                context.put(ContextKeys.StringKeys.TRANSACTION_KEY.name(), transactionId);
            }
            return mutationProvider.get().update(entityClass, Long.parseLong(id), this.recreate(Optional.ofNullable(argument).orElseGet(Collections::emptyMap)), context);
        }
        throw new RuntimeException("Update Mutation is not Support");
    }

    private String doDelete(DataFetchingEnvironment env, IEntityClass entityClass) {
        String id = (String)env.getArgument("id");
        Optional<MutationProvider> mutationProvider = this.mutationProviders.stream().filter(x -> x.accept(entityClass)).findFirst();
        if (mutationProvider.isPresent()) {
            Map<String, Object> context = this.getContext(env);
            String transactionId = this.getTransactionId(env);
            if (!StringUtils.isEmpty((CharSequence)transactionId)) {
                context.put(ContextKeys.StringKeys.TRANSACTION_KEY.name(), transactionId);
            }
            return mutationProvider.get().delete(entityClass, Long.parseLong(id), context);
        }
        throw new RuntimeException("Delete Mutation is not Support");
    }

    private String doBatchDelete(DataFetchingEnvironment env, IEntityClass entityClass) {
        List id = (List)env.getArgument("id");
        Optional<MutationProvider> mutationProvider = this.mutationProviders.stream().filter(x -> x.accept(entityClass)).findFirst();
        if (mutationProvider.isPresent()) {
            Map<String, Object> context = this.getContext(env);
            String transactionId = this.getTransactionId(env);
            if (!StringUtils.isEmpty((CharSequence)transactionId)) {
                context.put(ContextKeys.StringKeys.TRANSACTION_KEY.name(), transactionId);
            }
            return mutationProvider.get().batchDelete(entityClass, id.stream().map(Long::parseLong).collect(Collectors.toList()), context);
        }
        throw new RuntimeException("Delete Mutation is not Support");
    }

    private String doCustom(DataFetchingEnvironment env, IEntityClass entityClass) {
        Map argument = (Map)env.getArgument("_input");
        Optional<MutationProvider> mutationProvider = this.mutationProviders.stream().filter(x -> x.accept(entityClass)).findFirst();
        List directives = env.getFieldDefinition().getAppliedDirectives();
        String actionName = null;
        if (!directives.isEmpty()) {
            Optional<GraphQLAppliedDirective> custom = directives.stream().filter(x -> x.getName().equals(OqsTypesFactory.CUSTOM_APPLIED.getName())).findAny();
            if (custom.isPresent()) {
                GraphQLAppliedDirective customDirective = custom.get();
                GraphQLAppliedDirectiveArgument actionCodeArg = customDirective.getArgument("code");
                actionName = actionCodeArg.getValue().toString();
            } else {
                throw new RuntimeException("Mutation custom action is not present");
            }
        }
        if (mutationProvider.isPresent()) {
            Map<String, Object> context = this.getContext(env);
            String transactionId = this.getTransactionId(env);
            if (!StringUtils.isEmpty((CharSequence)transactionId)) {
                context.put(ContextKeys.StringKeys.TRANSACTION_KEY.name(), transactionId);
            }
            return mutationProvider.get().custom(entityClass, actionName, argument, context);
        }
        throw new RuntimeException("Custom Mutation is not Support");
    }

    private Map<String, Object> getContext(DataFetchingEnvironment env) {
        HashMap<String, Object> context = new HashMap<String, Object>(this.contextService.getAll());
        GraphQLContext graphQlContext = env.getGraphQlContext();
        if (graphQlContext != null) {
            graphQlContext.stream().forEach(x -> context.put(x.getKey().toString(), x.getValue()));
        }
        return context;
    }
}

