/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.graphql.gen;

import com.google.common.collect.Sets;
import com.xforceplus.metadata.schema.rels.MetadataRelationType;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.FieldLikeRelationType;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.EntityField;
import com.xforceplus.ultraman.sdk.graphql.gen.GraphQLGenTypes;
import com.xforceplus.ultraman.sdk.graphql.gen.OqsDataFetcher;
import com.xforceplus.ultraman.sdk.graphql.input.BooleanFilter;
import com.xforceplus.ultraman.sdk.graphql.input.DecimalFilter;
import com.xforceplus.ultraman.sdk.graphql.input.LongFilter;
import com.xforceplus.ultraman.sdk.graphql.input.StringFilter;
import com.xforceplus.ultraman.sdk.graphql.input.StringsFilter;
import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.scalars.ExtendedScalars;
import graphql.scalars.java.JavaPrimitives;
import graphql.scalars.object.JsonScalar;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OqsTypesFactory {
    private static final Logger log = LoggerFactory.getLogger(OqsTypesFactory.class);
    private EntityClassEngine engine;
    private DataFetcher oqsDataFetcher;
    private Map<Long, GraphQLInputType> inputTypeCache;
    private static final String DescriptionTemplate = "id:%s, name:%s";
    private static final String FILTER_NAME = "%sFilter";
    private static final String CREATE_NAME = "%sAdd";
    private static final String BATCH_CREATE_NAME = "%sBatchAdd";
    private static final String UPDATE_NAME = "%sUpdate";
    private static final String BATCH_UPDATE_NAME = "%sBatchUpdate";
    private static final String DELETE_NAME = "%sDelete";
    private static final String BATCH_DELETE_NAME = "%sBatchDelete";
    private static final String COMPANION_NAME = "%sObj";
    public static final String CODE_ARG = "code";
    public static final String TRANSACTIONAL = "transactional";
    public static final String FILTER_ARG = "_filter";
    public static final String ORDER_ARG = "_order";
    public static final String INPUT_ARG = "_input";
    public static final String ID_ARG = "id";
    private static final GraphQLArgument ID = GraphQLArgument.newArgument().name("id").type((GraphQLInputType)Scalars.GraphQLID).build();
    private static final GraphQLArgument IDS = GraphQLArgument.newArgument().name("id").type((GraphQLInputType)GraphQLList.list((GraphQLType)Scalars.GraphQLID)).build();
    private static final GraphQLArgument PAGE_NO = GraphQLArgument.newArgument().name("pageNo").type((GraphQLInputType)Scalars.GraphQLInt).build();
    private static final GraphQLArgument PAGE_SIZE = GraphQLArgument.newArgument().name("pageSize").type((GraphQLInputType)Scalars.GraphQLInt).build();
    private static final GraphQLInputType ORDER_INPUT = GraphQLList.list((GraphQLType)GraphQLInputObjectType.newInputObject().name("_orderList").field(GraphQLInputObjectField.newInputObjectField().name("code").type((GraphQLInputType)Scalars.GraphQLString).build()).field(GraphQLInputObjectField.newInputObjectField().name("_order").type((GraphQLInputType)GraphQLEnumType.newEnum().name("_order").value("ASC", (Object)"asc").value("DESC", (Object)"desc").build()).build()).build());
    private static final GraphQLArgument ORDER = GraphQLArgument.newArgument().name("_order").type(ORDER_INPUT).build();
    public static final GraphQLDirective TRANSACTIONAL_D = GraphQLDirective.newDirective().name("transactional").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.MUTATION}).build();
    public static final GraphQLAppliedDirective REMOTE_APPLIED = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("remote")).build();
    public static final GraphQLAppliedDirective TRANSACTIONAL_D_APPLIED = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("transactional")).build();
    public static final GraphQLAppliedDirective ORIGIN_APPLIED = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("origin")).build();
    public static final GraphQLAppliedDirective CODED_APPLIED = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("coded")).build();
    public static final GraphQLAppliedDirective CUSTOM_APPLIED = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("custom")).build();
    public static final GraphQLAppliedDirective ONE2ONE_APPLIED = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("one2one")).build();
    public static final GraphQLAppliedDirective ONE2MANY_APPLIED = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("one2many")).build();
    public static final GraphQLAppliedDirective MULTI_VALUES_APPLIED = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("multi")).build();
    public static final GraphQLAppliedDirective ADD = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("add")).build();
    public static final GraphQLAppliedDirective BATCH_ADD = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("batchAdd")).build();
    public static final GraphQLAppliedDirective UPDATE = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("update")).build();
    public static final GraphQLAppliedDirective BATCH_UPDATE = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("batchUpdate")).build();
    public static final GraphQLAppliedDirective DELETE = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("delete")).build();
    public static final GraphQLAppliedDirective BATCH_DELETE = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("batchDelete")).build();
    public static final GraphQLAppliedDirective UNBOX_APPLIED = ((GraphQLAppliedDirective.Builder)((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("unbox")).description("unbox from the list")).build();

    public OqsTypesFactory(EntityClassEngine engine, OqsDataFetcher oqsDataFetcher) {
        this.engine = engine;
        this.oqsDataFetcher = oqsDataFetcher;
    }

    public GraphQLSchema genSchema(String profile) {
        List allEntities = this.engine.findAllEntities(profile);
        GraphQLObjectType.Builder queryBuilder = GraphQLObjectType.newObject().name("Query");
        GraphQLObjectType.Builder mutationBuilder = GraphQLObjectType.newObject().name("Mutation");
        GraphQLCodeRegistry.Builder registryBuilder = GraphQLCodeRegistry.newCodeRegistry();
        ArrayList infList = new ArrayList();
        HashMap typeMapping = new HashMap();
        HashMap inputTypeMapping = new HashMap();
        HashMap listTypeMapping = new HashMap();
        HashMap interfaceMapping = new HashMap();
        allEntities.stream().map(x -> this.genGraphQLGen((IEntityClass)x, profile)).forEach(x -> {
            queryBuilder.field(x.getQueryType());
            mutationBuilder.field(x.getCreateType());
            mutationBuilder.field(x.getUpdateType());
            mutationBuilder.field(x.getDeleteType());
            mutationBuilder.field(x.getBatchCreateType());
            mutationBuilder.field(x.getBatchUpdateType());
            mutationBuilder.field(x.getBatchDeleteType());
            x.getCustomTypes().forEach(arg_0 -> ((GraphQLObjectType.Builder)mutationBuilder).field(arg_0));
            registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Query", (String)x.getQueryType().getName()), this.oqsDataFetcher);
            registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Mutation", (String)x.getCreateType().getName()), this.oqsDataFetcher);
            registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Mutation", (String)x.getUpdateType().getName()), this.oqsDataFetcher);
            registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Mutation", (String)x.getDeleteType().getName()), this.oqsDataFetcher);
            registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Mutation", (String)x.getBatchDeleteType().getName()), this.oqsDataFetcher);
            registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Mutation", (String)x.getBatchUpdateType().getName()), this.oqsDataFetcher);
            registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Mutation", (String)x.getBatchCreateType().getName()), this.oqsDataFetcher);
            x.getCustomTypes().forEach(custom -> registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Mutation", (String)custom.getName()), this.oqsDataFetcher));
            GraphQLObjectType objectType = x.getObjectType();
            objectType.getFieldDefinitions().stream().forEach(field -> {
                GraphQLAppliedDirective one2many = field.getAppliedDirective("one2many");
                GraphQLAppliedDirective one2one = field.getAppliedDirective("one2one");
                if (one2many != null) {
                    registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)objectType.getName(), (String)field.getName()), this.oqsDataFetcher);
                } else if (one2one != null) {
                    registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)objectType.getName(), (String)field.getName()), this.oqsDataFetcher);
                }
            });
            inputTypeMapping.put(x.getFilterTypeName(), x.getFilter());
            typeMapping.put(x.getTypeName(), x.getObjectType());
            listTypeMapping.put(x.getTypeName(), x.getListType());
            if (x.getInterfaceType() != null) {
                infList.add(x.getInterfaceType());
                interfaceMapping.put(x.getTypeName(), x.getInterfaceType());
                GraphQLInterfaceType interfaceType = x.getInterfaceType();
                interfaceType.getFieldDefinitions().stream().forEach(field -> {
                    GraphQLAppliedDirective one2many = field.getAppliedDirective("one2many");
                    GraphQLAppliedDirective one2one = field.getAppliedDirective("one2one");
                    if (one2many != null) {
                        registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)interfaceType.getName(), (String)field.getName()), this.oqsDataFetcher);
                    } else if (one2one != null) {
                        registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)interfaceType.getName(), (String)field.getName()), this.oqsDataFetcher);
                    }
                });
            }
        });
        infList.forEach(x -> registryBuilder.typeResolver(x, env -> {
            Optional retType;
            Object entityClassId;
            Object ret = env.getObject();
            if (ret instanceof Map && (entityClassId = ((Map)ret).get("_entityClassId")) != null && (retType = this.engine.load(entityClassId.toString(), "")).isPresent()) {
                return (GraphQLObjectType)typeMapping.get(((IEntityClass)retType.get()).code());
            }
            throw new RuntimeException("Not a Map");
        }));
        GraphQLSchema schema = GraphQLSchema.newSchema().codeRegistry(registryBuilder.build()).query(queryBuilder).additionalTypes(typeMapping.values().stream().collect(Collectors.toSet())).additionalTypes(inputTypeMapping.values().stream().collect(Collectors.toSet())).additionalTypes(interfaceMapping.values().stream().collect(Collectors.toSet())).additionalTypes(listTypeMapping.values().stream().collect(Collectors.toSet())).additionalDirectives((Set)Sets.newHashSet((Object[])new GraphQLDirective[]{TRANSACTIONAL_D})).mutation(mutationBuilder).build();
        return schema;
    }

    public GraphQLGenTypes genGraphQLGen(IEntityClass entityClass, String profile) {
        GraphQLGenTypes types = new GraphQLGenTypes();
        IEntityClass targetEntityClass = entityClass;
        EntityClassGroup group = this.engine.describe(targetEntityClass, profile);
        types.setTypeName(targetEntityClass.code());
        if (!group.getChildrenEntityClass().isEmpty()) {
            types.setInterfaceType(this.genInterfaceType(group));
        }
        String code = group.getEntityClass().code();
        String filterName = String.format(FILTER_NAME, code);
        types.setFilterTypeName(filterName);
        types.setFilter((GraphQLInputType)this.genFilter(group));
        types.setObjectType(this.genObjectType(group));
        types.setQueryType(this.genQueryType(group));
        types.setCustomTypes(this.genCustomType(group));
        types.setBatchCreateType(this.genBatchCreateType(group));
        types.setCreateType(this.genCreateType(group));
        types.setBatchUpdateType(this.genBatchUpdateType(group));
        types.setUpdateType(this.genUpdateType(group));
        types.setBatchDeleteType(this.genBatchDeleteType(group));
        types.setDeleteType(this.genDeleteType(group));
        types.setListType(this.genListType(group));
        return types;
    }

    private GraphQLObjectType genListType(EntityClassGroup group) {
        String objectName = group.getEntityClass().code();
        return GraphQLObjectType.newObject().name(objectName.concat("List")).field(GraphQLFieldDefinition.newFieldDefinition().name("totalCount").type((GraphQLOutputType)ExtendedScalars.GraphQLLong).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("row").type((GraphQLOutputType)GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)objectName))).build()).build();
    }

    private GraphQLFieldDefinition genQueryType(EntityClassGroup group) {
        String name = group.getEntityClass().code();
        String filterName = String.format(FILTER_NAME, name);
        GraphQLArgument filter = GraphQLArgument.newArgument().name(FILTER_ARG).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)filterName)).build();
        return ((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(name).arguments(Arrays.asList(filter, ORDER, PAGE_NO, PAGE_SIZE)).type((GraphQLOutputType)GraphQLTypeReference.typeRef((String)(name + "List"))).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)name).build()))).build();
    }

    private List<GraphQLFieldDefinition> genCustomType(EntityClassGroup group) {
        String name = group.getEntityClass().code();
        Set actions = this.engine.findCustomActionsById(group.getEntityClass().id());
        return actions.stream().map(x -> {
            String actionName = name.concat(x.substring(0, 1).toUpperCase().concat(x.substring(1)));
            GraphQLFieldDefinition fieldDefinition = ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(actionName).argument(GraphQLArgument.newArgument().name(INPUT_ARG).type((GraphQLInputType)JsonScalar.INSTANCE).build()).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)name).build()).build())).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CUSTOM_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic(x)).build())).type((GraphQLOutputType)Scalars.GraphQLString).build();
            return fieldDefinition;
        }).collect(Collectors.toList());
    }

    private GraphQLFieldDefinition genBatchCreateType(EntityClassGroup group) {
        String name = group.getEntityClass().code();
        String createName = String.format(BATCH_CREATE_NAME, name);
        GraphQLFieldDefinition fieldDefinition = ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(createName).argument(GraphQLArgument.newArgument().name(INPUT_ARG).type((GraphQLInputType)GraphQLList.list((GraphQLType)JsonScalar.INSTANCE)).build()).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)name).build()).build())).withAppliedDirective(BATCH_ADD)).type((GraphQLOutputType)Scalars.GraphQLString).build();
        return fieldDefinition;
    }

    private GraphQLFieldDefinition genCreateType(EntityClassGroup group) {
        String name = group.getEntityClass().code();
        String createName = String.format(CREATE_NAME, name);
        GraphQLFieldDefinition fieldDefinition = ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(createName).argument(GraphQLArgument.newArgument().name(INPUT_ARG).type((GraphQLInputType)JsonScalar.INSTANCE).build()).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)name).build()).build())).withAppliedDirective(ADD)).type((GraphQLOutputType)Scalars.GraphQLString).build();
        return fieldDefinition;
    }

    private GraphQLFieldDefinition genBatchUpdateType(EntityClassGroup group) {
        String name = group.getEntityClass().code();
        String operationName = String.format(BATCH_UPDATE_NAME, name);
        GraphQLFieldDefinition fieldDefinition = ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(operationName).argument(GraphQLArgument.newArgument().name(INPUT_ARG).type((GraphQLInputType)GraphQLList.list((GraphQLType)JsonScalar.INSTANCE)).build()).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)name).build()).build())).withAppliedDirective(BATCH_UPDATE)).type((GraphQLOutputType)Scalars.GraphQLString).build();
        return fieldDefinition;
    }

    private GraphQLFieldDefinition genUpdateType(EntityClassGroup group) {
        String name = group.getEntityClass().code();
        String createName = String.format(UPDATE_NAME, name);
        GraphQLFieldDefinition fieldDefinition = ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(createName).argument(ID).argument(GraphQLArgument.newArgument().name(INPUT_ARG).type((GraphQLInputType)JsonScalar.INSTANCE).build()).type((GraphQLOutputType)Scalars.GraphQLString).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)name).build()).build())).withAppliedDirective(UPDATE)).build();
        return fieldDefinition;
    }

    private GraphQLFieldDefinition genBatchDeleteType(EntityClassGroup group) {
        String name = group.getEntityClass().code();
        String deleteName = String.format(BATCH_DELETE_NAME, name);
        GraphQLFieldDefinition fieldDefinition = ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(deleteName).argument(IDS).type((GraphQLOutputType)Scalars.GraphQLString).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)name).build()).build())).withAppliedDirective(BATCH_DELETE)).build();
        return fieldDefinition;
    }

    private GraphQLFieldDefinition genDeleteType(EntityClassGroup group) {
        String name = group.getEntityClass().code();
        String deleteName = String.format(DELETE_NAME, name);
        GraphQLFieldDefinition fieldDefinition = ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(deleteName).argument(ID).type((GraphQLOutputType)Scalars.GraphQLString).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)name).build()).build())).withAppliedDirective(DELETE)).build();
        return fieldDefinition;
    }

    private GraphQLInputObjectType genFilter(EntityClassGroup group) {
        String code = group.getEntityClass().code();
        String filterName = String.format(FILTER_NAME, code);
        Collection allFields = group.getAllFields();
        List plainFields = allFields.stream().map(x -> {
            if (x.name().contains(".")) {
                GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField();
                builder.type(this.fieldTypeToFilterType(x.type()));
                String replace = x.name().replace('.', '_');
                return ((GraphQLInputObjectField.Builder)builder.name("_".concat(replace)).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)ORIGIN_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)x.name())).build())).build();
            }
            GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField().name(x.name()).description(x.cnName());
            GraphQLInputType fieldType = this.fieldTypeToFilterType(x.type());
            builder = builder.type(fieldType);
            return builder.build();
        }).collect(Collectors.toList());
        Collection childrenEntityClass = group.getChildrenEntityClass();
        List childInputObjectFields = Optional.ofNullable(childrenEntityClass).orElseGet(Collections::emptyList).stream().flatMap(child -> {
            String childCode = child.code();
            Collection fields = child.fields();
            return fields.stream().map(x -> {
                String name = x.name();
                if (!name.contains(".")) {
                    String childFilterName = childCode.concat("__SUB__").concat(name);
                    GraphQLInputObjectField.Builder builder = GraphQLInputObjectField.newInputObjectField().name(childFilterName).description(x.cnName());
                    GraphQLInputType fieldType = this.fieldTypeToFilterType(x.type());
                    builder = builder.type(fieldType);
                    return builder.build();
                }
                return null;
            }).filter(Objects::nonNull);
        }).collect(Collectors.toList());
        List relatedFilter = group.getAllRelations().stream().map(rel -> {
            Optional related = group.relatedEntityClass(rel.getName());
            if (related.isPresent()) {
                String referFilter = String.format(FILTER_NAME, ((IEntityClass)related.get()).code());
                return GraphQLInputObjectField.newInputObjectField().name(rel.getName()).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)referFilter)).build();
            }
            log.warn("Related EntityClass not present {}", (Object)rel.getName());
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<Object> fields = new ArrayList<Object>(plainFields.size() + relatedFilter.size() + 2);
        fields.addAll(plainFields);
        fields.addAll(childInputObjectFields);
        fields.addAll(relatedFilter);
        GraphQLInputObjectField and = GraphQLInputObjectField.newInputObjectField().name("and").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)filterName))).build();
        GraphQLInputObjectField or = GraphQLInputObjectField.newInputObjectField().name("or").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)filterName))).build();
        fields.add(and);
        fields.add(or);
        return GraphQLInputObjectType.newInputObject().name(filterName).fields(fields).build();
    }

    private GraphQLInputType fieldTypeToFilterType(FieldType type) {
        GraphQLInputType fieldType = null;
        switch (type) {
            case STRINGS: {
                fieldType = StringsFilter.INSTANCE;
                break;
            }
            case LONG: {
                fieldType = LongFilter.INSTANCE;
                break;
            }
            case DECIMAL: {
                fieldType = DecimalFilter.INSTANCE;
                break;
            }
            case DATETIME: {
                fieldType = LongFilter.INSTANCE;
                break;
            }
            case BOOLEAN: {
                fieldType = BooleanFilter.INSTANCE;
                break;
            }
            default: {
                fieldType = StringFilter.INSTANCE;
            }
        }
        return fieldType;
    }

    private GraphQLOutputType fieldTypeToObjectType(FieldType type) {
        GraphQLScalarType fieldType = null;
        switch (type) {
            case STRINGS: {
                fieldType = Scalars.GraphQLString;
                break;
            }
            case LONG: {
                fieldType = JavaPrimitives.GraphQLLong;
                break;
            }
            case DECIMAL: {
                fieldType = JavaPrimitives.GraphQLBigDecimal;
                break;
            }
            case DATETIME: {
                fieldType = JavaPrimitives.GraphQLLong;
                break;
            }
            case BOOLEAN: {
                fieldType = Scalars.GraphQLBoolean;
                break;
            }
            default: {
                fieldType = Scalars.GraphQLString;
            }
        }
        return fieldType;
    }

    private GraphQLInterfaceType genInterfaceType(EntityClassGroup group) {
        String name = group.getEntityClass().code();
        Collection fatherEntityClass = group.getFatherEntityClass();
        List<GraphQLFieldDefinition> fieldDefinitions = this.fieldsToGraphQLFieldDefinition(group.getAllFields());
        Map<String, List<IRelation>> relationsMapping = group.getAllRelations().stream().collect(Collectors.groupingBy(x -> Optional.ofNullable(x.getRelationType()).orElse("")));
        List relatedFields = group.getAllRelations().stream().map(rel -> {
            Optional related = group.relatedEntityClass(rel.getName());
            if (related.isPresent()) {
                if (rel.getRelationType().equalsIgnoreCase(MetadataRelationType.TO_MANY.toString())) {
                    boolean isSelf = Optional.ofNullable(relationsMapping.get(FieldLikeRelationType.MANY2ONE.getName())).orElseGet(Collections::emptyList).stream().anyMatch(x -> x.getName().equalsIgnoreCase(rel.getName().concat("MTO")));
                    return ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(rel.getName()).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)ONE2MANY_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)(isSelf ? rel.getName().concat("MTO") : rel.getName())).build()).build())).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)name).build()).build())).type((GraphQLOutputType)GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)((IEntityClass)related.get()).code()))).build();
                }
                if (rel.getRelationType().equalsIgnoreCase(MetadataRelationType.TO_ONE.toString())) {
                    return ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(rel.getName()).withAppliedDirective(ONE2ONE_APPLIED)).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)name).build()).build())).type((GraphQLOutputType)GraphQLTypeReference.typeRef((String)((IEntityClass)related.get()).code())).build();
                }
                if (rel.getRelationType().equalsIgnoreCase(FieldLikeRelationType.MULTI_VALUES.getName())) {
                    return ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(rel.getName()).withAppliedDirective(MULTI_VALUES_APPLIED)).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)name).build()).build())).type((GraphQLOutputType)GraphQLTypeReference.typeRef((String)((IEntityClass)related.get()).code())).build();
                }
                log.warn("Related Type is unknown {}", (Object)rel.getName());
                return null;
            }
            log.warn("Related EntityClass not present {}", (Object)rel.getName());
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        GraphQLInterfaceType.Builder infBuilder = GraphQLInterfaceType.newInterface().name(name).fields(new ArrayList<GraphQLFieldDefinition>(fieldDefinitions)).fields(relatedFields);
        if (!fatherEntityClass.isEmpty()) {
            fatherEntityClass.forEach(x -> infBuilder.withInterface(GraphQLTypeReference.typeRef((String)x.code())));
        }
        return infBuilder.build();
    }

    private List<GraphQLFieldDefinition> fieldsToGraphQLFieldDefinition(Collection<IEntityField> allFields) {
        List<GraphQLFieldDefinition> plainFields = allFields.stream().map(x -> {
            if (x.name().contains(".")) {
                GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
                builder.type(this.fieldTypeToObjectType(x.type()));
                String replace = x.name().replace('.', '_');
                return ((GraphQLFieldDefinition.Builder)builder.name("_".concat(replace)).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)ORIGIN_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)x.name()).build()).build())).build();
            }
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            GraphQLOutputType fieldType = this.fieldTypeToObjectType(x.type());
            builder.name(x.name());
            builder = builder.type(fieldType);
            return builder.build();
        }).collect(Collectors.toList());
        return plainFields;
    }

    private Collection<IEntityField> makeupId(Collection<IEntityField> allFields) {
        Optional<IEntityField> fieldOp = allFields.stream().filter(x -> ID_ARG.equals(x.name())).findAny();
        if (!fieldOp.isPresent()) {
            ArrayList<IEntityField> newList = new ArrayList<IEntityField>(allFields);
            newList.add((IEntityField)new EntityField(-1L, ID_ARG, FieldType.STRING));
            return newList;
        }
        return allFields;
    }

    private GraphQLObjectType genObjectType(EntityClassGroup group) {
        String objectName = group.getEntityClass().code();
        boolean isCompanion = false;
        if (!group.getChildrenEntityClass().isEmpty()) {
            objectName = String.format(COMPANION_NAME, objectName);
            isCompanion = true;
        }
        Collection<IEntityField> allFields = group.getAllFields();
        allFields = this.makeupId(allFields);
        Map<String, List<IRelation>> relationsMapping = group.getAllRelations().stream().collect(Collectors.groupingBy(x -> Optional.ofNullable(x.getRelationType()).map(String::toLowerCase).orElse("")));
        List<GraphQLFieldDefinition> plainFields = this.fieldsToGraphQLFieldDefinition(allFields);
        List relatedFields = group.getAllRelations().stream().map(rel -> {
            Optional related = group.relatedEntityClass(rel.getName());
            if (related.isPresent()) {
                if (rel.getRelationType().equalsIgnoreCase(MetadataRelationType.TO_MANY.name())) {
                    boolean isSelf = Optional.ofNullable(relationsMapping.get(FieldLikeRelationType.MANY2ONE.getName())).orElseGet(Collections::emptyList).stream().anyMatch(x -> x.getName().equalsIgnoreCase(rel.getName().concat("MTO")));
                    return ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(rel.getName()).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)ONE2MANY_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)(isSelf ? rel.getName().concat("MTO") : rel.getName())).build()).build())).withAppliedDirective(UNBOX_APPLIED)).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)((IEntityClass)related.get()).code()).build()).build())).type((GraphQLOutputType)GraphQLList.list((GraphQLType)GraphQLTypeReference.typeRef((String)((IEntityClass)related.get()).code()))).build();
                }
                if (rel.getRelationType().equalsIgnoreCase(MetadataRelationType.TO_ONE.name())) {
                    return ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(rel.getName()).withAppliedDirective(ONE2ONE_APPLIED)).withAppliedDirective(UNBOX_APPLIED)).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)((IEntityClass)related.get()).code()).build()).build())).type((GraphQLOutputType)GraphQLTypeReference.typeRef((String)((IEntityClass)related.get()).code())).build();
                }
                if (rel.getRelationType().equalsIgnoreCase(FieldLikeRelationType.MULTI_VALUES.getName())) {
                    return ((GraphQLFieldDefinition.Builder)((GraphQLFieldDefinition.Builder)GraphQLFieldDefinition.newFieldDefinition().name(rel.getName()).withAppliedDirective(MULTI_VALUES_APPLIED)).withAppliedDirective(GraphQLAppliedDirective.newDirective((GraphQLAppliedDirective)CODED_APPLIED).argument(((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(CODE_ARG)).type((GraphQLInputType)Scalars.GraphQLString).valueProgrammatic((Object)((IEntityClass)related.get()).code()).build()).build())).type((GraphQLOutputType)GraphQLTypeReference.typeRef((String)((IEntityClass)related.get()).code())).build();
                }
                log.warn("Related Type is unknown {}", (Object)rel.getName());
                return null;
            }
            log.warn("Related EntityClass not present {}", (Object)rel.getName());
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<Object> fields = new ArrayList<Object>(plainFields.size() + relatedFields.size());
        fields.addAll(plainFields);
        fields.addAll(relatedFields);
        String objectCName = group.getEntityClass().name();
        long objectId = group.getEntityClass().id();
        String description = String.format(DescriptionTemplate, objectId, objectCName);
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(objectName).description(description).fields(fields);
        if (group.getEntityClass().getType() == 1) {
            builder.withAppliedDirective(REMOTE_APPLIED);
        }
        if (isCompanion) {
            builder.withInterface(GraphQLTypeReference.typeRef((String)group.getEntityClass().code()));
        }
        if (!group.getFatherEntityClass().isEmpty()) {
            group.getFatherEntityClass().forEach(parent -> builder.withInterface(GraphQLTypeReference.typeRef((String)parent.code())));
        }
        return builder.build();
    }
}

