/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.graphql.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.FieldLikeRelationType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.cmd.BatchCreateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.BatchDeleteCmd;
import com.xforceplus.ultraman.sdk.core.cmd.BatchUpdateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import com.xforceplus.ultraman.sdk.core.cmd.CustomActionCmd;
import com.xforceplus.ultraman.sdk.core.cmd.HeadAndDetailsCreateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.MetaDataLikeCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleCreateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleDeleteCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleQueryCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleUpdateCmd;
import com.xforceplus.ultraman.sdk.core.facade.MutationProvider;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.QueryProvider;
import com.xforceplus.ultraman.sdk.core.facade.remote.RemoteExecutionResponse;
import com.xforceplus.ultraman.sdk.core.service.EntityHandlerService;
import com.xforceplus.ultraman.sdk.graphql.config.GraphQLSchemaHolder;
import com.xforceplus.ultraman.sdk.graphql.gen.BatchDataLoader;
import com.xforceplus.ultraman.sdk.graphql.utils.GraphQLHelper;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.execution.ExecutionId;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DefaultEntityHandlerService
implements EntityHandlerService {
    private static final Logger log = LoggerFactory.getLogger(DefaultEntityHandlerService.class);
    @Autowired
    private EntityClassEngine engine;
    @Autowired
    private GraphQLSchemaHolder holder;
    @Autowired
    private List<QueryProvider> queryProviders;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private ProfileFetcher fetcher;
    @Autowired
    private MutationProvider mutationProvider;
    @Autowired
    private ContextService contextService;
    @Value(value="${xplat.oqsengine.sdk.query.strict:true}")
    private boolean isStrict;
    private static final String MISSING_ENTITIES = "\u67e5\u8be2\u5bf9\u8c61\u4e0d\u5b58\u5728";
    private static final String MISSING_ENTITY = "\u67e5\u8be2\u8bb0\u5f55\u4e0d\u5b58\u5728";

    public boolean isStrict() {
        return this.isStrict;
    }

    public void setStrict(boolean strict) {
        this.isStrict = strict;
    }

    public GraphQLSchemaHolder getHolder() {
        return this.holder;
    }

    public void setHolder(GraphQLSchemaHolder holder) {
        this.holder = holder;
    }

    public EntityClassEngine getEngine() {
        return this.engine;
    }

    public void setEngine(EntityClassEngine engine) {
        this.engine = engine;
    }

    public List<QueryProvider> getQueryProviders() {
        return this.queryProviders;
    }

    public void setQueryProviders(List<QueryProvider> queryProviders) {
        this.queryProviders = queryProviders;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ProfileFetcher getFetcher() {
        return this.fetcher;
    }

    public void setFetcher(ProfileFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public ContextService getContextService() {
        return this.contextService;
    }

    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }

    private Optional<IEntityClass> getEntityClass(MetaDataLikeCmd cmd) {
        return Optional.ofNullable(cmd.version()).map(x -> this.engine.load(cmd.getBoId(), this.fetcher.getProfile(Collections.emptyMap()), cmd.version())).orElseGet(() -> this.engine.load(cmd.getBoId(), this.fetcher.getProfile(Collections.emptyMap())));
    }

    private Map<String, Object> queryCmdToMap(SingleQueryCmd cmd) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("_objId", cmd.getId());
        queryMap.put("_classId", cmd.getBoId());
        queryMap.put("_version", cmd.version());
        return queryMap;
    }

    private Map<String, Object> conditionQueryCmdToMap(ConditionSearchCmd cmd) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("_condition", cmd.getConditionQueryRequest());
        queryMap.put("_version", cmd.version());
        queryMap.put("_classId", cmd.getBoId());
        return queryMap;
    }

    private Map<String, Object> deleteCmdToMap(SingleDeleteCmd cmd) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("_objId", cmd.getId());
        queryMap.put("_classId", cmd.getBoId());
        queryMap.put("_version", cmd.version());
        return queryMap;
    }

    private Map<String, Object> multiDeleteCmdToMap(BatchDeleteCmd cmd) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("_objIds", cmd.getIds());
        queryMap.put("_classId", cmd.getBoId());
        queryMap.put("_version", cmd.version());
        return queryMap;
    }

    private Map<String, Object> updateCmdToMap(SingleUpdateCmd cmd) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.putAll(cmd.getBody());
        bodyMap.put("_objId", cmd.getId());
        bodyMap.put("_version", cmd.version());
        bodyMap.put("_classId", cmd.getBoId());
        return bodyMap;
    }

    private Map<String, Object> batchUpdateCmdToMap(BatchUpdateCmd cmd) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("_bodies", cmd.getBodies());
        bodyMap.put("_version", cmd.version());
        bodyMap.put("_classId", cmd.getBoId());
        return bodyMap;
    }

    private Map<String, Object> createCmdToMap(SingleCreateCmd cmd) {
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.putAll(cmd.getBody());
        bodyMap.put("_version", cmd.version());
        bodyMap.put("_classId", cmd.getBoId());
        return bodyMap;
    }

    @QueryHandler(isDefault=true)
    public Either<String, Map<String, Object>> singleQuery(SingleQueryCmd cmd) {
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        try {
            Optional<IEntityClass> entityClassOp = this.getEntityClass((MetaDataLikeCmd)cmd);
            if (!entityClassOp.isPresent()) {
                return Either.left((Object)MISSING_ENTITIES);
            }
            IEntityClass entityClass = entityClassOp.get();
            ExecutionInput executionInput = this.toInput(entityClass, this.engine, profile, cmd, null, this.isStrict);
            ExecutionResult execute = this.holder.getGraphQL(profile).execute(executionInput);
            List errors = execute.getErrors();
            if (!errors.isEmpty()) {
                throw new RuntimeException(errors.stream().map(x -> "" + x.getMessage()).collect(Collectors.joining(",")));
            }
            Map data = (Map)execute.getData();
            Object o = data.get(entityClass.code());
            if (o instanceof Map) {
                Object row = ((Map)o).get("row");
                List rawList = Optional.ofNullable(row).map(x -> (List)x).orElseGet(Collections::emptyList);
                List flattened = rawList.stream().map(x -> {
                    if (x instanceof Map) {
                        HashMap<String, Object> retMap = new HashMap<String, Object>();
                        this.flattenMap((Map)x, retMap, "");
                        return retMap;
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                if (!flattened.isEmpty()) {
                    return Either.right(GraphQLHelper.reNormalize((Map)flattened.get(0)));
                }
                return Either.left((Object)MISSING_ENTITY);
            }
            throw new RuntimeException("Type error");
        }
        catch (Exception ex) {
            log.error("ConditionSearch Error {}", (Throwable)ex);
            return Either.left((Object)ex.getMessage());
        }
    }

    @QueryHandler(isDefault=true)
    public Either<String, Integer> batchDelete(BatchDeleteCmd cmd) {
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        try {
            Optional<IEntityClass> entityClassOp = this.getEntityClass((MetaDataLikeCmd)cmd);
            if (!entityClassOp.isPresent()) {
                return Either.left((Object)MISSING_ENTITIES);
            }
            IEntityClass entityClass = entityClassOp.get();
            ExecutionInput executionInput = this.toInput(entityClass, cmd, "");
            ExecutionResult execute = this.holder.getGraphQL(profile).execute(executionInput);
            List errors = execute.getErrors();
            if (!errors.isEmpty()) {
                throw new RuntimeException(errors.stream().map(x -> "" + x.getMessage()).collect(Collectors.joining(",")));
            }
            Object data = execute.getData();
            if (data instanceof Map) {
                Map dataMap = (Map)data;
                Integer affectRow = Optional.ofNullable(dataMap.get(entityClass.code().concat("BatchDelete"))).map(x -> Integer.parseInt(x.toString())).orElse(-1);
                return Either.right((Object)affectRow);
            }
            return Either.right((Object)-1);
        }
        catch (Exception ex) {
            log.error("Delete error {}", (Throwable)ex);
            return Either.left((Object)ex.getMessage());
        }
    }

    @QueryHandler(isDefault=true)
    public Either<String, Integer> singleDelete(SingleDeleteCmd cmd) {
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        try {
            ExecutionResult execute;
            List errors;
            String relations;
            Optional<IEntityClass> entityClassOp = this.getEntityClass((MetaDataLikeCmd)cmd);
            if (!entityClassOp.isPresent()) {
                return Either.left((Object)MISSING_ENTITIES);
            }
            IEntityClass entityClass = entityClassOp.get();
            ExecutionInput executionInput = this.toInput(entityClass, cmd, "");
            Object context = executionInput.getContext();
            if (context instanceof GraphQLContext && !StringUtils.isEmpty((CharSequence)(relations = cmd.getRelations()))) {
                log.info("delete with details {} {}", (Object)entityClass.code(), (Object)relations);
                ((GraphQLContext)context).put((Object)"relations", (Object)cmd.getRelations());
            }
            if (!(errors = (execute = this.holder.getGraphQL(profile).execute(executionInput)).getErrors()).isEmpty()) {
                throw new RuntimeException(errors.stream().map(x -> "" + x.getMessage()).collect(Collectors.joining(",")));
            }
            return Either.right((Object)1);
        }
        catch (Exception ex) {
            log.error("Delete error {}", (Throwable)ex);
            return Either.left((Object)ex.getMessage());
        }
    }

    @QueryHandler(isDefault=true)
    public Either<String, Integer> batchCreate(BatchCreateCmd cmd) {
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        try {
            Optional<IEntityClass> entityClassOp = this.getEntityClass((MetaDataLikeCmd)cmd);
            if (!entityClassOp.isPresent()) {
                return Either.left((Object)MISSING_ENTITIES);
            }
            IEntityClass entityClass = entityClassOp.get();
            ExecutionInput executionInput = this.toInput(entityClass, cmd, "");
            ExecutionResult execute = this.holder.getGraphQL(profile).execute(executionInput);
            List errors = execute.getErrors();
            if (!errors.isEmpty()) {
                throw new RuntimeException(errors.stream().map(x -> "" + x.getMessage()).collect(Collectors.joining(",")));
            }
            Object data = execute.getData();
            if (data instanceof Map) {
                Map dataMap = (Map)data;
                Integer affectRow = Optional.ofNullable(dataMap.get(entityClass.code().concat("BatchAdd"))).map(x -> Integer.parseInt(x.toString())).orElse(-1);
                return Either.right((Object)affectRow);
            }
            return Either.right((Object)-1);
        }
        catch (Exception ex) {
            log.error("Batch Create error {}", (Throwable)ex);
            return Either.left((Object)ex.getMessage());
        }
    }

    @QueryHandler(isDefault=true)
    public Either<String, Long> singleCreate(SingleCreateCmd cmd) {
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        try {
            Optional<IEntityClass> entityClassOp = this.getEntityClass((MetaDataLikeCmd)cmd);
            if (!entityClassOp.isPresent()) {
                return Either.left((Object)MISSING_ENTITIES);
            }
            IEntityClass entityClass = entityClassOp.get();
            ExecutionInput executionInput = this.toInput(entityClass, cmd, "");
            ExecutionResult execute = this.holder.getGraphQL(profile).execute(executionInput);
            List errors = execute.getErrors();
            if (!errors.isEmpty()) {
                throw new RuntimeException(errors.stream().map(x -> "" + x.getMessage()).collect(Collectors.joining(",")));
            }
            Object data = execute.getData();
            if (data instanceof Map) {
                Map dataMap = (Map)data;
                Long id = Optional.ofNullable(dataMap.get(entityClass.code().concat("Add"))).map(x -> Long.parseLong(x.toString())).orElse(-1L);
                return Either.right((Object)id);
            }
            return Either.right((Object)-1L);
        }
        catch (Exception ex) {
            return Either.left((Object)ex.getMessage());
        }
    }

    private Map<String, Object> getResult(RemoteExecutionResponse response) {
        Object result = response.getResult();
        Map resultMapping = new HashMap();
        if (result != null) {
            if (result instanceof Tuple2) {
                Tuple2 tuple = (Tuple2)result;
                List maps = (List)tuple._2();
                if (!maps.isEmpty()) {
                    resultMapping = (Map)maps.get(0);
                }
            } else {
                resultMapping = (Map)result;
            }
            return resultMapping;
        }
        return Collections.emptyMap();
    }

    @QueryHandler(isDefault=true)
    public Either<String, Integer> batchUpdate(BatchUpdateCmd cmd) {
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        try {
            Optional<IEntityClass> entityClassOp = this.getEntityClass((MetaDataLikeCmd)cmd);
            if (!entityClassOp.isPresent()) {
                return Either.left((Object)MISSING_ENTITIES);
            }
            IEntityClass entityClass = entityClassOp.get();
            ExecutionInput executionInput = this.toInput(entityClass, cmd, "");
            ExecutionResult execute = this.holder.getGraphQL(profile).execute(executionInput);
            List errors = execute.getErrors();
            if (!errors.isEmpty()) {
                throw new RuntimeException(errors.stream().map(x -> "" + x.getMessage()).collect(Collectors.joining(",")));
            }
            Object data = execute.getData();
            if (data instanceof Map) {
                Map dataMap = (Map)data;
                Integer affectRow = Optional.ofNullable(dataMap.get(entityClass.code().concat("BatchUpdate"))).map(x -> Integer.parseInt(x.toString())).orElse(-1);
                return Either.right((Object)affectRow);
            }
            return Either.right((Object)-1);
        }
        catch (Exception ex) {
            log.error("Batch Update error {}", (Throwable)ex);
            return Either.left((Object)ex.getMessage());
        }
    }

    @QueryHandler(isDefault=true)
    public Either<String, Integer> headAndDetailsCreate(HeadAndDetailsCreateCmd cmd) {
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        try {
            Optional<IEntityClass> entityClassOp = this.getEntityClass((MetaDataLikeCmd)cmd);
            if (!entityClassOp.isPresent()) {
                return Either.left((Object)MISSING_ENTITIES);
            }
            IEntityClass entityClass = entityClassOp.get();
            EntityClassGroup group = this.engine.describe(entityClass, profile);
            ExecutionInput mainCreateInput = this.toInput(entityClass, new SingleCreateCmd(cmd.getBoId(), cmd.getMainBody(), cmd.version()), "");
            ExecutionResult execute = this.holder.getGraphQL(profile).execute(mainCreateInput);
            List errors = execute.getErrors();
            if (!errors.isEmpty()) {
                throw new RuntimeException(errors.stream().map(x -> "" + x.getMessage()).collect(Collectors.joining(",")));
            }
            Object data = execute.getData();
            if (data instanceof Map) {
                Map dataMap = (Map)data;
                Long id = Optional.ofNullable(dataMap.get(entityClass.code().concat("Add"))).map(x -> Long.parseLong(x.toString())).orElse(-1L);
                Collection relations = Optional.ofNullable(entityClass.relations()).orElseGet(Collections::emptyList);
                cmd.getRelatedBodies().stream().filter(x -> relations.stream().anyMatch(rel -> rel.getName().equals(x._1) && FieldLikeRelationType.ONE2MANY.getName().equalsIgnoreCase(rel.getRelationType()))).forEach(tuple -> {
                    Optional relatedEntityClass = group.relatedEntityClass((String)tuple._1());
                    List relatedDataList = (List)tuple._2;
                    relatedDataList.forEach(relatedData -> relatedData.put(((String)tuple._1).concat(".id"), id));
                    ExecutionInput subCreateInput = this.toInput((IEntityClass)relatedEntityClass.get(), new BatchCreateCmd(Long.toString(((IEntityClass)relatedEntityClass.get()).id()), relatedDataList, cmd.version()), "");
                    ExecutionResult subExecutionResult = this.holder.getGraphQL(profile).execute(subCreateInput);
                    List subErrors = subExecutionResult.getErrors();
                    if (!subErrors.isEmpty()) {
                        throw new RuntimeException(subErrors.stream().map(x -> "" + x.getMessage()).collect(Collectors.joining(",")));
                    }
                });
                return Either.right((Object)1);
            }
            throw new RuntimeException("Record Id is Missing");
        }
        catch (Exception ex) {
            log.error("Head Detail Update error {}", (Throwable)ex);
            throw ex;
        }
    }

    @QueryHandler(isDefault=true)
    public Either<String, Object> customAction(CustomActionCmd cmd) {
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        try {
            Optional<IEntityClass> entityClassOp = this.getEntityClass((MetaDataLikeCmd)cmd);
            if (!entityClassOp.isPresent()) {
                return Either.left((Object)MISSING_ENTITIES);
            }
            IEntityClass entityClass = entityClassOp.get();
            ExecutionInput executionInput = this.toInput(entityClass, cmd, "");
            log.debug("[SDK]:{}", (Object)executionInput);
            ExecutionResult execute = this.holder.getGraphQL(profile).execute(executionInput);
            List errors = execute.getErrors();
            if (!errors.isEmpty()) {
                throw new RuntimeException(errors.stream().map(x -> "" + x.getMessage()).collect(Collectors.joining(",")));
            }
            return Either.right((Object)execute.getData());
        }
        catch (Exception ex) {
            return Either.left((Object)ex.getMessage());
        }
    }

    @QueryHandler(isDefault=true)
    public Either<String, Integer> singleUpdate(SingleUpdateCmd cmd) {
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        try {
            Optional<IEntityClass> entityClassOp = this.getEntityClass((MetaDataLikeCmd)cmd);
            if (!entityClassOp.isPresent()) {
                return Either.left((Object)MISSING_ENTITIES);
            }
            IEntityClass entityClass = entityClassOp.get();
            ExecutionInput executionInput = this.toInput(entityClass, cmd, "null");
            log.debug("[SDK]:{}", (Object)executionInput);
            ExecutionResult execute = this.holder.getGraphQL(profile).execute(executionInput);
            List errors = execute.getErrors();
            if (!errors.isEmpty()) {
                throw new RuntimeException(errors.stream().map(x -> "" + x.getMessage()).collect(Collectors.joining(",")));
            }
            return Either.right((Object)1);
        }
        catch (Exception ex) {
            return Either.left((Object)ex.getMessage());
        }
    }

    private ExecutionInput toInput(String queryString, DataLoaderRegistry registry, String traceId) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(queryString).dataLoaderRegistry(registry).variables(this.contextService.getAll()).executionId(ExecutionId.from((String)traceId)).build();
        GraphQLContext context = (GraphQLContext)executionInput.getContext();
        this.contextService.getAll().forEach((k, v) -> {
            if (v == null) {
                log.warn("{} has a null value", k);
            } else {
                context.put(k, v);
            }
        });
        log.debug("[QueryString] {}", (Object)queryString);
        return executionInput;
    }

    private ExecutionInput toInput(String queryString, String traceId) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(queryString).variables(this.contextService.getAll()).executionId(ExecutionId.from((String)traceId)).build();
        GraphQLContext context = (GraphQLContext)executionInput.getContext();
        this.contextService.getAll().forEach((k, v) -> {
            if (v == null) {
                log.warn("{} has a null value", k);
            } else {
                context.put(k, v);
            }
        });
        log.debug("[QueryString] {}", (Object)queryString);
        return executionInput;
    }

    private ExecutionInput toInput(IEntityClass entityClass, CustomActionCmd cmd, String traceId) {
        String queryString = GraphQLHelper.customString(entityClass, cmd);
        return this.toInput(queryString, traceId);
    }

    private ExecutionInput toInput(IEntityClass entityClass, BatchCreateCmd cmd, String traceId) {
        String queryString = GraphQLHelper.batchCreateString(entityClass, cmd);
        return this.toInput(queryString, traceId);
    }

    private ExecutionInput toInput(IEntityClass entityClass, BatchUpdateCmd cmd, String traceId) {
        String queryString = GraphQLHelper.batchUpdateString(entityClass, cmd);
        return this.toInput(queryString, traceId);
    }

    private ExecutionInput toInput(IEntityClass entityClass, BatchDeleteCmd cmd, String traceId) {
        String queryString = GraphQLHelper.batchDeleteString(entityClass, cmd);
        return this.toInput(queryString, traceId);
    }

    private ExecutionInput toInput(IEntityClass entityClass, SingleCreateCmd cmd, String traceId) {
        String queryString = GraphQLHelper.singleCreateString(entityClass, cmd);
        return this.toInput(queryString, traceId);
    }

    private ExecutionInput toInput(IEntityClass entityClass, SingleUpdateCmd cmd, String traceId) {
        String queryString = GraphQLHelper.singleUpdateString(entityClass, cmd);
        return this.toInput(queryString, traceId);
    }

    private ExecutionInput toInput(IEntityClass entityClass, SingleDeleteCmd cmd, String traceId) {
        String queryString = GraphQLHelper.singleDeleteString(entityClass, cmd);
        return this.toInput(queryString, traceId);
    }

    private ExecutionInput toInput(IEntityClass entityClass, EntityClassEngine engine, String profile, SingleQueryCmd cmd, String traceId, boolean isStrict) {
        String queryString = GraphQLHelper.singleQueryString(entityClass, engine, profile, cmd, isStrict);
        return this.toInput(queryString, traceId);
    }

    private ExecutionInput toInput(IEntityClass entityClass, EntityClassEngine engine, String profile, ConditionSearchCmd cmd, String traceId, boolean isStrict) {
        DataLoaderRegistry registry = new DataLoaderRegistry();
        engine.codes().forEach(code -> registry.computeIfAbsent(code, lazy -> DataLoader.newDataLoader((BatchLoaderWithContext)new BatchDataLoader(this.queryProviders))));
        String queryString = GraphQLHelper.conditionToQueryString(entityClass, engine, profile, cmd, isStrict);
        return this.toInput(queryString, registry, traceId);
    }

    @QueryHandler(isDefault=true)
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        String profile = this.fetcher.getProfile(Collections.emptyMap());
        try {
            Optional<IEntityClass> entityClassOp = this.getEntityClass((MetaDataLikeCmd)cmd);
            if (!entityClassOp.isPresent()) {
                return Either.left((Object)MISSING_ENTITIES);
            }
            IEntityClass entityClass = entityClassOp.get();
            ExecutionInput executionInput = this.toInput(entityClass, this.engine, profile, cmd, "", this.isStrict);
            ExecutionResult execute = this.holder.getGraphQL(profile).execute(executionInput);
            List errors = execute.getErrors();
            if (!errors.isEmpty()) {
                throw new RuntimeException(errors.stream().map(x -> "" + x.getMessage()).collect(Collectors.joining(",")));
            }
            Map data = (Map)execute.getData();
            Object o = data.get(entityClass.code());
            if (o instanceof Map) {
                Object row = ((Map)o).get("row");
                Object totalCount = ((Map)o).get("totalCount");
                List rawList = Optional.ofNullable(row).map(x -> (List)x).orElseGet(Collections::emptyList);
                List flattened = rawList.stream().map(x -> {
                    if (x instanceof Map) {
                        HashMap<String, Object> retMap = new HashMap<String, Object>();
                        this.flattenMap((Map)x, retMap, "");
                        return GraphQLHelper.reNormalize(retMap);
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return Either.right((Object)Tuple.of((Object)Integer.parseInt(Optional.ofNullable(totalCount).orElse("0").toString()), flattened));
            }
            throw new RuntimeException("Type error");
        }
        catch (Exception ex) {
            log.error("ConditionSearch Error {}", (Throwable)ex);
            return Either.left((Object)ex.getMessage());
        }
    }

    private void flattenMap(Map<String, Object> value, Map<String, Object> dest, String prefix) {
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            if (entry.getValue() instanceof Map) {
                this.flattenMap((Map)entry.getValue(), dest, StringUtils.isEmpty((CharSequence)prefix) ? entry.getKey() : prefix.concat(".").concat(entry.getKey()));
                continue;
            }
            dest.put(StringUtils.isEmpty((CharSequence)prefix) ? entry.getKey() : prefix.concat(".").concat(entry.getKey()), entry.getValue());
        }
    }
}

