/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.graphql.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Conditions;
import com.xforceplus.ultraman.metadata.domain.vo.dto.EntityItem;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.helper.RequestBuilder;
import com.xforceplus.ultraman.sdk.core.cmd.BatchCreateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.BatchDeleteCmd;
import com.xforceplus.ultraman.sdk.core.cmd.BatchUpdateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import com.xforceplus.ultraman.sdk.core.cmd.CustomActionCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleCreateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleDeleteCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleQueryCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleUpdateCmd;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class GraphQLHelper {
    public static final String SUB_TOKEN = "__SUB__";
    private static final String DELETE_TEMPLATE = "mutation { %sDelete(id:%s) }";
    private static final String UPDATE_TEMPLATE = "mutation { %sUpdate(id:%s, _input:%s) }";
    private static final String CREATE_TEMPLATE = "mutation { %sAdd(_input:%s) }";
    private static final String BATCH_DELETE_TEMPLATE = "mutation { %sBatchDelete(id:[%s]) }";
    private static final String BATCH_CREATE_TEMPLATE = "mutation { %sBatchAdd(_input:%s) }";
    private static final String BATCH_UPDATE_TEMPLATE = "mutation { %sBatchUpdate(_input:%s) }";
    private static final String ORDER_TEMPLATE = "{code:\"%s\", _order:%s}";
    private static final String CUSTOM_TEMPLATE = "mutation { %s%s(_input:%s) }";
    private static ObjectMapper mapper = new ObjectMapper();

    public static String conditionToQueryString(IEntityClass entityClass, EntityClassEngine engine, String profile, ConditionSearchCmd cmd, boolean isStrict) {
        ConditionQueryRequest conditionQueryRequest = cmd.getConditionQueryRequest();
        return GraphQLHelper.toQueryString(entityClass, engine, profile, conditionQueryRequest, isStrict);
    }

    public static String singleUpdateString(IEntityClass entityClass, SingleUpdateCmd cmd) {
        String code = entityClass.code();
        Long id = cmd.getId();
        Map body = cmd.getBody();
        String jsonStr = GraphQLHelper.toJson(GraphQLHelper.normalize(body));
        return String.format(UPDATE_TEMPLATE, code, id, jsonStr);
    }

    public static String singleCreateString(IEntityClass entityClass, SingleCreateCmd cmd) {
        String code = entityClass.code();
        Map body = cmd.getBody();
        String jsonStr = GraphQLHelper.toJson(GraphQLHelper.normalize(body));
        return String.format(CREATE_TEMPLATE, code, jsonStr);
    }

    public static String batchDeleteString(IEntityClass entityClass, BatchDeleteCmd cmd) {
        String code = entityClass.code();
        List ids = cmd.getIds();
        String idsStr = ids.stream().collect(Collectors.joining(","));
        return String.format(BATCH_DELETE_TEMPLATE, code, idsStr);
    }

    public static String batchCreateString(IEntityClass entityClass, BatchCreateCmd cmd) {
        String code = entityClass.code();
        List bodies = cmd.getBodies();
        List newBodies = bodies.stream().map(x -> GraphQLHelper.normalize(x)).collect(Collectors.toList());
        String inputStr = GraphQLHelper.toJson(newBodies);
        return String.format(BATCH_CREATE_TEMPLATE, code, inputStr);
    }

    public static Map<String, Object> normalize(Map<String, Object> argument) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        argument.forEach((k, v) -> {
            String key = k;
            if (k.contains(".")) {
                key = "_".concat(k.replace('.', '_'));
            } else if (k.contains("/") || k.contains(":")) {
                k = k.replaceFirst("/", SUB_TOKEN);
                key = k = k.replaceFirst(":", SUB_TOKEN);
            }
            map.put(key, v);
        });
        return map;
    }

    public static String normalize(String name) {
        if (name.contains(".")) {
            return "_".concat(name.replace('.', '_'));
        }
        if (name.contains("/") || name.contains(":")) {
            name = name.replaceFirst("/", SUB_TOKEN);
            name = name.replaceFirst(":", SUB_TOKEN);
            return name;
        }
        return name;
    }

    public static Map<String, Object> reNormalize(Map<String, Object> argument) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        argument.forEach((k, v) -> map.put(GraphQLHelper.reNormalize(k), v));
        return map;
    }

    public static String reNormalize(String k) {
        String key = k;
        if (key.startsWith("_")) {
            key = key.substring(1).replaceFirst("_", ".");
        }
        if (key.contains(SUB_TOKEN)) {
            key = key.replaceFirst(SUB_TOKEN, "/");
        }
        return key;
    }

    public static String customString(IEntityClass entityClass, CustomActionCmd cmd) {
        String actionCode = cmd.getActionName();
        String actionCodeFormat = actionCode.substring(0, 1).toUpperCase() + actionCode.substring(1);
        String code = entityClass.code();
        Map customInput = cmd.getCustomInput();
        String inputStr = GraphQLHelper.toJson(customInput);
        return String.format(CUSTOM_TEMPLATE, code, actionCodeFormat, inputStr);
    }

    public static String batchUpdateString(IEntityClass entityClass, BatchUpdateCmd cmd) {
        String code = entityClass.code();
        List bodies = cmd.getBodies();
        List newBodies = bodies.stream().map(x -> GraphQLHelper.normalize(x)).collect(Collectors.toList());
        String inputStr = GraphQLHelper.toJson(newBodies);
        return String.format(BATCH_UPDATE_TEMPLATE, code, inputStr);
    }

    private static String toJson(Object body) {
        try {
            String json = mapper.writeValueAsString(body);
            return json;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String singleDeleteString(IEntityClass entityClass, SingleDeleteCmd cmd) {
        String id = cmd.getId();
        String code = entityClass.code();
        return String.format(DELETE_TEMPLATE, code, id);
    }

    public static String singleQueryString(IEntityClass entityClass, EntityClassEngine engine, String profile, SingleQueryCmd cmd, boolean isStrict) {
        String id = cmd.getId();
        EntityClassGroup group = engine.describe(entityClass, profile);
        String[] codes = (String[])group.getAllFields().stream().map(x -> {
            String name = x.name();
            if (name.contains(".")) {
                return "_".concat(name.replace('.', '_'));
            }
            return name;
        }).toArray(String[]::new);
        ConditionQueryRequest idRequest = new RequestBuilder().field("id", ConditionOp.eq, new Object[]{id}).item(codes).pageNo(Integer.valueOf(1)).pageSize(Integer.valueOf(1)).build();
        return GraphQLHelper.toQueryString(entityClass, engine, profile, idRequest, isStrict);
    }

    private static String expandSubField(String sub) {
        String[] split;
        if (sub.contains(SUB_TOKEN) && (split = sub.split(SUB_TOKEN)).length > 1) {
            StringBuilder fragement = new StringBuilder();
            fragement.append("... on ");
            fragement.append(split[0]);
            fragement.append(" { ");
            fragement.append(sub).append(":").append(split[1]);
            fragement.append(" } ");
            return fragement.toString();
        }
        return sub;
    }

    private static String toCondition(Conditions conditions) {
        StringBuilder filterBuilder = new StringBuilder();
        Optional.ofNullable(conditions).ifPresent(x -> {
            if (conditions.getGroups() != null && !conditions.getGroups().isEmpty()) {
                String operation = conditions.getOperation();
                filterBuilder.append(operation);
                filterBuilder.append(":[");
                String condition = conditions.getGroups().stream().map(group -> GraphQLHelper.toCondition(group)).map(filter -> "{ ".concat((String)filter).concat("}")).collect(Collectors.joining(","));
                filterBuilder.append(condition);
                filterBuilder.append("]");
            } else {
                Optional.ofNullable(x.getFields()).orElseGet(Collections::emptyList).forEach(field -> {
                    String fieldCode = field.getCode();
                    ConditionOp operation = field.getOperation();
                    List value = field.getValue();
                    filterBuilder.append(" ").append(GraphQLHelper.normalize(fieldCode)).append(":").append(" {").append(operation.name()).append(":").append(GraphQLHelper.valueString(operation, value)).append(" },");
                });
                Optional.ofNullable(x.getEntities()).orElseGet(Collections::emptyList).forEach(sub -> {
                    filterBuilder.append(sub.getCode()).append(":{");
                    Optional.ofNullable(sub.getFields()).ifPresent(subF -> subF.stream().forEach(field -> {
                        String fieldCode = field.getCode();
                        ConditionOp operation = field.getOperation();
                        List value = field.getValue();
                        filterBuilder.append(" ").append(GraphQLHelper.normalize(fieldCode)).append(" :{").append(operation.name()).append(":").append(GraphQLHelper.valueString(operation, value)).append(" },");
                    }));
                    Optional.ofNullable(sub.getEntities()).orElseGet(Collections::emptyList).forEach(nestedSub -> {
                        filterBuilder.append("").append(nestedSub.getCode()).append(": {");
                        Optional.ofNullable(nestedSub.getFields()).ifPresent(subF -> subF.stream().forEach(field -> {
                            String fieldCode = field.getCode();
                            ConditionOp operation = field.getOperation();
                            List value = field.getValue();
                            filterBuilder.append(" ").append(GraphQLHelper.normalize(fieldCode)).append(" :{").append(operation.name()).append(":").append(GraphQLHelper.valueString(operation, value)).append(" },");
                        }));
                        filterBuilder.append("}");
                    });
                    filterBuilder.append("}");
                });
            }
        });
        return filterBuilder.toString();
    }

    public static String toQueryString(IEntityClass entityClass, EntityClassEngine engine, String profile, ConditionQueryRequest conditionQueryRequest, boolean isStrict) {
        EntityClassGroup group = engine.describe(entityClass, profile);
        StringBuilder stringBuilder = new StringBuilder();
        String code = entityClass.code();
        StringBuilder subBuilder = new StringBuilder();
        subBuilder.append("row {");
        EntityItem entity = conditionQueryRequest.getEntity();
        List<String> fields = Optional.ofNullable(entity).map(EntityItem::getFields).map(x -> x.stream().map(y -> GraphQLHelper.normalize(y)).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        if (fields.isEmpty()) {
            fields = group.getAllFields().stream().map(x -> GraphQLHelper.normalize(x.name())).collect(Collectors.toList());
        }
        fields.forEach(x -> subBuilder.append(GraphQLHelper.expandSubField(x)).append(" "));
        Optional.ofNullable(entity).map(EntityItem::getEntities).orElseGet(Collections::emptyList).stream().forEach(sub -> {
            subBuilder.append(sub.getCode()).append(" ");
            List subFields = sub.getFields();
            if (subFields != null && !subFields.isEmpty()) {
                subBuilder.append(" {");
                subFields.forEach(s -> subBuilder.append(GraphQLHelper.expandSubField(GraphQLHelper.normalize(s))).append(" "));
                subBuilder.append(" }");
            }
        });
        subBuilder.append(" }");
        subBuilder.append(" totalCount");
        Conditions conditions = conditionQueryRequest.getConditions();
        StringBuilder filterBuilder = new StringBuilder("_filter:{");
        filterBuilder.append(GraphQLHelper.toCondition(conditions));
        filterBuilder.append("}");
        StringBuilder orderBuilder = new StringBuilder();
        List sort = conditionQueryRequest.getSort();
        String orderListStr = Optional.ofNullable(sort).orElseGet(Collections::emptyList).stream().map(x -> String.format(ORDER_TEMPLATE, x.getField(), "desc".equals(x.getOrder()) ? "DESC" : "ASC")).collect(Collectors.joining(","));
        orderBuilder.append("_order");
        orderBuilder.append(": [ ");
        orderBuilder.append(orderListStr);
        orderBuilder.append("]");
        StringBuilder rangeBuilder = new StringBuilder();
        Integer pageNo = conditionQueryRequest.getPageNo();
        Integer pageSize = conditionQueryRequest.getPageSize();
        rangeBuilder.append("pageNo:").append(pageNo).append(",");
        rangeBuilder.append("pageSize:").append(pageSize);
        stringBuilder.append("query {").append(code).append("(").append((CharSequence)filterBuilder).append(",").append((CharSequence)orderBuilder).append(",").append((CharSequence)rangeBuilder).append(")").append(" {");
        stringBuilder.append((CharSequence)subBuilder);
        stringBuilder.append(" }}");
        return stringBuilder.toString();
    }

    private static String valueString(ConditionOp op, List<String> value) {
        StringBuilder valueBuilder = new StringBuilder();
        if (op.getSize() > 2) {
            valueBuilder.append("[");
            valueBuilder.append(value.stream().map(v -> "\"".concat(GraphQLHelper.escapeValue(v)).concat("\"")).collect(Collectors.joining(",")));
            valueBuilder.append("]");
            return valueBuilder.toString();
        }
        return value.isEmpty() ? null : "\"".concat(GraphQLHelper.escapeValue(value.get(0))).concat("\"");
    }

    private static String escapeValue(String value) {
        if (value != null) {
            return value.replaceAll("\"", "\\\\\"");
        }
        return value;
    }

    static {
        mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(EmptyValue.class, (JsonSerializer)new JsonSerializer<EmptyValue>(){

            public void serialize(EmptyValue emptyValue, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeNull();
            }
        });
        mapper.registerModule((Module)simpleModule);
    }
}

