package com.xforceplus.ultraman.sdk.graphql.config;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.repository.MetadataRepository;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.QueryProvider;
import com.xforceplus.ultraman.sdk.graphql.gen.BatchDataLoader;
import com.xforceplus.ultraman.sdk.infra.base.ExecutionConfig;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.spring.web.servlet.GraphQLInvocation;
import graphql.spring.web.servlet.GraphQLInvocationData;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DataLoaderRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.WebRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public class InnerGraphQLInvocation implements GraphQLInvocation {

    @Autowired
    private GraphQLSchemaHolder holder;

    @Autowired
    private ProfileFetcher fetcher;

    @Autowired
    private ContextService contextService;

    @Autowired
    private EntityClassEngine engine;

    @Autowired
    private List<QueryProvider> queryProviders;

    public Map<String, Object> predicateMap;

    public InnerGraphQLInvocation(ExecutionConfig executionConfig) {

        Predicate<Class<?>> predicate = new Predicate<Class<?>>() {
            @Override
            public boolean test(Class<?> aClass) {
                List<String> skipRules = executionConfig.getSkipRules();
                if (skipRules.contains(aClass.getSimpleName())) {
                    return false;
                }
                return true;
            }
        };
        predicateMap = new HashMap<>();
        predicateMap.put("graphql.ParseAndValidate.Predicate", predicate);
    }

    @Override
    public CompletableFuture<ExecutionResult> invoke(GraphQLInvocationData invocationData
            , WebRequest webRequest) {

        DataLoaderRegistry registry = new DataLoaderRegistry();
        //prepare
        engine.codes().forEach(code -> {
            registry.computeIfAbsent(code, lazy -> DataLoaderFactory.newDataLoader(new BatchDataLoader(queryProviders)));
        });

        ExecutionInput executionInput = ExecutionInput.newExecutionInput()
                .query(invocationData.getQuery())
                .graphQLContext(predicateMap)
                .operationName(invocationData.getOperationName())
                .variables(invocationData.getVariables())
                .dataLoaderRegistry(registry)
                //.executionId(executionId)
                .build();

        GraphQL graphQL = holder.getGraphQL(fetcher.getProfile(contextService.getAll()));
        CompletableFuture<ExecutionResult> executionResultCompletableFuture = graphQL.executeAsync(executionInput);
        return executionResultCompletableFuture;
    }

    public Map<String, Object> getPredicateMap() {
        return predicateMap;
    }
}
